/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.SearchSort;
import com.mypurecloud.sdk.v2.model.UserSearchCriteria;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserSearchRequest
implements Serializable {
    private SortOrderEnum sortOrder = null;
    private String sortBy = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private List<SearchSort> sort = new ArrayList<SearchSort>();
    private List<String> expand = new ArrayList<String>();
    private List<UserSearchCriteria> query = new ArrayList<UserSearchCriteria>();
    private IntegrationPresenceSourceEnum integrationPresenceSource = null;
    private Boolean enforcePermissions = null;

    public UserSearchRequest sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public UserSearchRequest sortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the resource that you want to sort the results by")
    @JsonProperty(value="sortBy")
    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public UserSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public UserSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The page of resources you want to retrieve")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public UserSearchRequest sort(List<SearchSort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Multi-value sort order, list of multiple sort values")
    @JsonProperty(value="sort")
    public List<SearchSort> getSort() {
        return this.sort;
    }

    public void setSort(List<SearchSort> sort) {
        this.sort = sort;
    }

    public UserSearchRequest expand(List<String> expand) {
        this.expand = expand;
        return this;
    }

    @ApiModelProperty(example="null", value="Provides more details about a specified resource")
    @JsonProperty(value="expand")
    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public UserSearchRequest query(List<UserSearchCriteria> query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="query")
    public List<UserSearchCriteria> getQuery() {
        return this.query;
    }

    public void setQuery(List<UserSearchCriteria> query) {
        this.query = query;
    }

    public UserSearchRequest integrationPresenceSource(IntegrationPresenceSourceEnum integrationPresenceSource) {
        this.integrationPresenceSource = integrationPresenceSource;
        return this;
    }

    @ApiModelProperty(example="null", value="Gets an integration presence for users instead of their defaults. This parameter will only be used when presence is provided as an \"expand\". When using this parameter the maximum number of users that can be returned is 10.")
    @JsonProperty(value="integrationPresenceSource")
    public IntegrationPresenceSourceEnum getIntegrationPresenceSource() {
        return this.integrationPresenceSource;
    }

    public void setIntegrationPresenceSource(IntegrationPresenceSourceEnum integrationPresenceSource) {
        this.integrationPresenceSource = integrationPresenceSource;
    }

    public UserSearchRequest enforcePermissions(Boolean enforcePermissions) {
        this.enforcePermissions = enforcePermissions;
        return this;
    }

    @ApiModelProperty(example="null", value="Enforce view permission on request")
    @JsonProperty(value="enforcePermissions")
    public Boolean getEnforcePermissions() {
        return this.enforcePermissions;
    }

    public void setEnforcePermissions(Boolean enforcePermissions) {
        this.enforcePermissions = enforcePermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearchRequest userSearchRequest = (UserSearchRequest)o;
        return Objects.equals((Object)this.sortOrder, (Object)userSearchRequest.sortOrder) && Objects.equals(this.sortBy, userSearchRequest.sortBy) && Objects.equals(this.pageSize, userSearchRequest.pageSize) && Objects.equals(this.pageNumber, userSearchRequest.pageNumber) && Objects.equals(this.sort, userSearchRequest.sort) && Objects.equals(this.expand, userSearchRequest.expand) && Objects.equals(this.query, userSearchRequest.query) && Objects.equals((Object)this.integrationPresenceSource, (Object)userSearchRequest.integrationPresenceSource) && Objects.equals(this.enforcePermissions, userSearchRequest.enforcePermissions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortOrder, this.sortBy, this.pageSize, this.pageNumber, this.sort, this.expand, this.query, this.integrationPresenceSource, this.enforcePermissions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSearchRequest {\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString(this.sortBy)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    expand: ").append(this.toIndentedString(this.expand)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    integrationPresenceSource: ").append(this.toIndentedString((Object)this.integrationPresenceSource)).append("\n");
        sb.append("    enforcePermissions: ").append(this.toIndentedString(this.enforcePermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum IntegrationPresenceSourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MICROSOFTTEAMS("MicrosoftTeams"),
        ZOOMPHONE("ZoomPhone");

        private String value;

        private IntegrationPresenceSourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IntegrationPresenceSourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IntegrationPresenceSourceEnum value : IntegrationPresenceSourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IntegrationPresenceSourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("ASC"),
        DESC("DESC"),
        SCORE("SCORE");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

