/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DocumentFaq;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import com.mypurecloud.sdk.v2.model.KnowledgeCategory;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocument
implements Serializable {
    private String id = null;
    private String name = null;
    private LanguageCodeEnum languageCode = null;
    private TypeEnum type = null;
    private DocumentFaq faq = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private List<KnowledgeCategory> categories = new ArrayList<KnowledgeCategory>();
    private KnowledgeBase knowledgeBase = null;
    private String externalUrl = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeDocument name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KnowledgeDocument languageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Language of the document")
    @JsonProperty(value="languageCode")
    public LanguageCodeEnum getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
    }

    public KnowledgeDocument type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Document type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public KnowledgeDocument faq(DocumentFaq faq) {
        this.faq = faq;
        return this;
    }

    @ApiModelProperty(example="null", value="FAQ document details")
    @JsonProperty(value="faq")
    public DocumentFaq getFaq() {
        return this.faq;
    }

    public void setFaq(DocumentFaq faq) {
        this.faq = faq;
    }

    @ApiModelProperty(example="null", value="Document creation date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Document last modification date-time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public KnowledgeDocument categories(List<KnowledgeCategory> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", value="Document categories")
    @JsonProperty(value="categories")
    public List<KnowledgeCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(List<KnowledgeCategory> categories) {
        this.categories = categories;
    }

    public KnowledgeDocument knowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge base which document does belong to")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    public KnowledgeDocument externalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="External URL to the document")
    @JsonProperty(value="externalUrl")
    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocument knowledgeDocument = (KnowledgeDocument)o;
        return Objects.equals(this.id, knowledgeDocument.id) && Objects.equals(this.name, knowledgeDocument.name) && Objects.equals((Object)this.languageCode, (Object)knowledgeDocument.languageCode) && Objects.equals((Object)this.type, (Object)knowledgeDocument.type) && Objects.equals(this.faq, knowledgeDocument.faq) && Objects.equals(this.dateCreated, knowledgeDocument.dateCreated) && Objects.equals(this.dateModified, knowledgeDocument.dateModified) && Objects.equals(this.categories, knowledgeDocument.categories) && Objects.equals(this.knowledgeBase, knowledgeDocument.knowledgeBase) && Objects.equals(this.externalUrl, knowledgeDocument.externalUrl) && Objects.equals(this.selfUri, knowledgeDocument.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.languageCode, this.type, this.faq, this.dateCreated, this.dateModified, this.categories, this.knowledgeBase, this.externalUrl, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocument {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString((Object)this.languageCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    faq: ").append(this.toIndentedString(this.faq)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    externalUrl: ").append(this.toIndentedString(this.externalUrl)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAQ("Faq");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum LanguageCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_US("en-US"),
        DE_DE("de-DE");

        private String value;

        private LanguageCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageCodeEnum value : LanguageCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

