/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ScimV2Group;
import java.util.HashMap;
import java.util.Map;

public class PutScimGroupRequest {
    private String groupId;
    private ScimV2Group body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PutScimGroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public ScimV2Group getBody() {
        return this.body;
    }

    public void setBody(ScimV2Group body) {
        this.body = body;
    }

    public PutScimGroupRequest withBody(ScimV2Group body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PutScimGroupRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutScimGroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ScimV2Group> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutScimGroupRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimGroupRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/scim/groups/{groupId}").withPathParameter("groupId", this.groupId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, ScimV2Group body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PutScimGroupRequest request = new PutScimGroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(ScimV2Group body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId, ScimV2Group body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PutScimGroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PutScimGroupRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutScimGroupRequest.");
            }
            return this.request;
        }
    }
}

