/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetConversationsCallRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public GetConversationsCallRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsCallRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() throws ApiException {
        if (this.callId == null) {
            throw new ApiException(400, "Missing the required parameter 'callId' when building request for GetConversationsCallRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/calls/{callId}").withPathParameter("callId", this.callId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId) {
        return new Builder().withRequiredParams(callId);
    }

    public static class Builder {
        private final GetConversationsCallRequest request = new GetConversationsCallRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withRequiredParams(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public GetConversationsCallRequest build() {
            return this.request;
        }
    }
}

