/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RoutingStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutUserRoutingstatusRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String userId;
    private RoutingStatus body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutUserRoutingstatusRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public RoutingStatus getBody() {
        return this.body;
    }

    public void setBody(RoutingStatus body) {
        this.body = body;
    }

    public PutUserRoutingstatusRequest withBody(RoutingStatus body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserRoutingstatusRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoutingStatus> withHttpInfo() throws ApiException {
        if (this.userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when building request for PutUserRoutingstatusRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutUserRoutingstatusRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/users/{userId}/routingstatus").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, RoutingStatus body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PutUserRoutingstatusRequest request = new PutUserRoutingstatusRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(RoutingStatus body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, RoutingStatus body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PutUserRoutingstatusRequest build() {
            return this.request;
        }
    }
}

