/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CampaignSequence;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostOutboundSequencesRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private CampaignSequence body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public CampaignSequence getBody() {
        return this.body;
    }

    public void setBody(CampaignSequence body) {
        this.body = body;
    }

    public PostOutboundSequencesRequest withBody(CampaignSequence body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostOutboundSequencesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CampaignSequence> withHttpInfo() throws ApiException {
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostOutboundSequencesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/outbound/sequences").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CampaignSequence body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostOutboundSequencesRequest request = new PostOutboundSequencesRequest();

        private Builder() {
        }

        public Builder withBody(CampaignSequence body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(CampaignSequence body) {
            this.request.setBody(body);
            return this;
        }

        public PostOutboundSequencesRequest build() {
            return this.request;
        }
    }
}

