/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatchUserQueueRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String queueId;
    private String userId;
    private UserQueue body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PatchUserQueueRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchUserQueueRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public UserQueue getBody() {
        return this.body;
    }

    public void setBody(UserQueue body) {
        this.body = body;
    }

    public PatchUserQueueRequest withBody(UserQueue body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchUserQueueRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserQueue> withHttpInfo() throws ApiException {
        if (this.queueId == null) {
            throw new ApiException(400, "Missing the required parameter 'queueId' when building request for PatchUserQueueRequest.");
        }
        if (this.userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when building request for PatchUserQueueRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PatchUserQueueRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/users/{userId}/queues/{queueId}").withPathParameter("queueId", this.queueId).withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, String userId, UserQueue body) {
        return new Builder().withRequiredParams(queueId, userId, body);
    }

    public static class Builder {
        private final PatchUserQueueRequest request = new PatchUserQueueRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(UserQueue body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String queueId, String userId, UserQueue body) {
            this.request.setQueueId(queueId);
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PatchUserQueueRequest build() {
            return this.request;
        }
    }
}

