/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Agent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOutboundCampaignAgentRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String campaignId;
    private String userId;
    private Agent body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public PutOutboundCampaignAgentRequest withCampaignId(String campaignId) {
        this.setCampaignId(campaignId);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutOutboundCampaignAgentRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public Agent getBody() {
        return this.body;
    }

    public void setBody(Agent body) {
        this.body = body;
    }

    public PutOutboundCampaignAgentRequest withBody(Agent body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOutboundCampaignAgentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Agent> withHttpInfo() throws ApiException {
        if (this.campaignId == null) {
            throw new ApiException(400, "Missing the required parameter 'campaignId' when building request for PutOutboundCampaignAgentRequest.");
        }
        if (this.userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when building request for PutOutboundCampaignAgentRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PutOutboundCampaignAgentRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/outbound/campaigns/{campaignId}/agents/{userId}").withPathParameter("campaignId", this.campaignId).withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String campaignId, String userId, Agent body) {
        return new Builder().withRequiredParams(campaignId, userId, body);
    }

    public static class Builder {
        private final PutOutboundCampaignAgentRequest request = new PutOutboundCampaignAgentRequest();

        private Builder() {
        }

        public Builder withCampaignId(String campaignId) {
            this.request.setCampaignId(campaignId);
            return this;
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(Agent body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String campaignId, String userId, Agent body) {
            this.request.setCampaignId(campaignId);
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PutOutboundCampaignAgentRequest build() {
            return this.request;
        }
    }
}

