package com.mygraphql.graphub.server.standalone;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import picocli.CommandLine;

import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.Callable;

/**
 * http://localhost:8080/graphql
 */
@SpringBootApplication
@CommandLine.Command(name = "graphserver",
        /*defaultValueProvider = GraphubServerApplication.DefaultValueProvider.class, */

        mixinStandardHelpOptions = true, version = "graphserver 0.1",
        description = "Graphub - mix REST API / Database to GraphQL service.\n Run Pet example server: graphserver -gclasspath://pet-graphub.graphqls -cREST=classpath://pet-graphub-restapi-connector.json"
)
public class GraphubServerApplication implements Callable<Integer> {

    private static final Logger log = LoggerFactory.getLogger(GraphubServerApplication.class);

    private static volatile GraphubServerApplication APP;

//    @CommandLine.Parameters(index = "0", description = "The file whose checksum to calculate.") private File file;

    @CommandLine.Option(
            names = [ "-g", "--graphqlschema_file" ],
            description = "Graphql schema file. E.g -g/home/user1/mygraphql_schema.graphqls",
            required = true
            )
    private String graphqlschemaFile = "classpath://graphub.graphqls";

    @CommandLine.Option(
            names = [ "-c", "--connectorEnvFile" ],
            required = false,
            description = "Connector configuration file. E.g: -cREST=/home/user1/rest_env.json",
            defaultValue = "=")
    private Map<String, String> connectorEnvFileMap;

    @CommandLine.Option(
            names = [ "-e", "--connectorEnv" ],
            required = false,
            description = "Connector inline configuration. E.g: -eREST='{\"endpoints\":{\"PetService\":{\"endpoint\":\"http://host1:80/pet\"},\"OtherService\":{\"endpoint\":\"http://host2:80/OtherService\"}}}'",
            defaultValue = "="
            )
    private Map<String, String> connectorEnvMap;
//defaultValue = "-cREST='{\"endpoints\":{\"PetService\":{\"endpoint\":\"http://localhost:9191/pet\"}}}'"

    private String[] mainArgs;

    @Override public Integer call()  {
        log.info("graphqlschemaFile=$graphqlschemaFile");
        log.info("connectorEnvFileMap=$connectorEnvFileMap");
        log.info("connectorEnvMap=$connectorEnvMap");

        APP = this;

        SpringApplication.run(GraphubServerApplication.class, mainArgs);

        log.info("GraphQL access endpoint: http://localhost:8080/graphql")

        return 0;
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine(new GraphubServerApplication(mainArgs: args)).execute(args);
        if( exitCode != 0 )
            System.exit(exitCode)
    }

//    public static class DefaultValueProvider implements CommandLine.IDefaultValueProvider {
//
//        @Override public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
//            return null;
//        }
//    }

    public String getGraphqlschemaFile() {
        return graphqlschemaFile
    }

    public Map<String, String> getConnectorEnvFileMap() {
        return connectorEnvFileMap
    }

    public Map<String, String> getConnectorEnvMap() {
        return connectorEnvMap
    }

    static GraphubServerApplication getAPP() {
        return APP
    }
}