package com.mygraphql.graphub.server.standalone

import com.mygraphql.graphub.server.ConnectorFactoryManager
import com.mygraphql.graphub.server.GraphQLProvider
import com.mygraphql.graphub.server.connector.ConnectorEnv
import com.mygraphql.graphub.server.connector.ConnectorFactory
import com.mygraphql.graphub.server.connectors.restapi.RestConnectorEnv
import com.mygraphql.graphub.server.connectors.restapi.RestConnectorFactory
import com.mygraphql.graphub.server.util.ResourceLoader
import graphql.GraphQL
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Bean
import org.springframework.stereotype.Component

import javax.annotation.PostConstruct

import static org.apache.commons.lang3.StringUtils.isBlank

@Component
public class SpringGraphQLProvider extends GraphQLProvider {

    GraphubServerApplication application;

    @PostConstruct
    public void init() throws IOException {

        application = GraphubServerApplication.APP

        Map<ConnectorFactory, ConnectorEnv> connectorFactoryConnectorEnvMap = [:]
        application.getConnectorEnvFileMap().forEach{
            connectorName, connectorEnvFile ->
                if( isBlank( connectorName ) )
                    return
                ConnectorFactory connectorFactory = ConnectorFactoryManager.getConnectorFactory(connectorName);
                connectorFactoryConnectorEnvMap.put( connectorFactory, connectorFactory.getEnvFromString( ResourceLoader.load(connectorEnvFile) ) )
        }
        application.getConnectorEnvMap().forEach{
            connectorName, connectorEnvText ->
                if( isBlank( connectorName ) )
                    return
                ConnectorFactory connectorFactory = ConnectorFactoryManager.getConnectorFactory(connectorName);
                connectorFactoryConnectorEnvMap.put( connectorFactory, connectorFactory.getEnvFromString( connectorEnvText ) )
        }

        String graphqlSchema = ResourceLoader.load(application.getGraphqlschemaFile());

        super.init(graphqlSchema, connectorFactoryConnectorEnvMap)
    }

    @Bean
    public GraphQL graphQL() {
        return super.graphQL();
    }

}
