/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.git.GitPathResolver;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitLookup {
    public static final TimeZone DEFAULT_ZONE = TimeZone.getTimeZone("GMT");
    public static final int DEFAULT_COMMITS_COUNT = 10;
    private final int checkCommitsCount;
    private final DateSource dateSource;
    private final GitPathResolver pathResolver;
    private final Repository repository;
    private final TimeZone timeZone;

    public GitLookup(File anyFile, DateSource dateSource, TimeZone timeZone, int checkCommitsCount) throws IOException {
        this.repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(anyFile)).build();
        this.repository.getObjectDatabase().newReader().getShallowCommits();
        this.pathResolver = new GitPathResolver(this.repository.getWorkTree().getAbsolutePath());
        this.dateSource = dateSource;
        switch (dateSource) {
            case COMMITER: {
                this.timeZone = timeZone == null ? DEFAULT_ZONE : timeZone;
                break;
            }
            case AUTHOR: {
                if (timeZone != null) {
                    throw new IllegalArgumentException("Time zone must be null with dateSource " + DateSource.AUTHOR.name() + " because git author name already contrains time zone information.");
                }
                this.timeZone = null;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected " + DateSource.class.getName() + " " + (Object)((Object)dateSource));
            }
        }
        this.checkCommitsCount = checkCommitsCount;
    }

    int getYearOfLastChange(File file) throws NoHeadException, GitAPIException, IOException {
        String repoRelativePath = this.pathResolver.relativize(file);
        if (this.isFileModifiedOrUnstaged(repoRelativePath)) {
            return this.getCurrentYear();
        }
        int commitYear = 0;
        RevWalk walk = this.getGitRevWalk(repoRelativePath, false);
        for (RevCommit commit : walk) {
            int y = this.getYearFromCommit(commit);
            if (y <= commitYear) continue;
            commitYear = y;
        }
        walk.dispose();
        return commitYear;
    }

    int getYearOfCreation(File file) throws IOException, GitAPIException {
        String repoRelativePath = this.pathResolver.relativize(file);
        if (this.isFileModifiedOrUnstaged(repoRelativePath)) {
            return this.getCurrentYear();
        }
        int commitYear = 0;
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            commitYear = this.getYearFromCommit(commit);
        }
        walk.dispose();
        return commitYear;
    }

    String getAuthorNameOfCreation(File file) throws IOException, GitAPIException {
        String repoRelativePath = this.pathResolver.relativize(file);
        String authorName = "";
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            authorName = this.getAuthorNameFromCommit(commit);
        }
        walk.dispose();
        return authorName;
    }

    String getAuthorEmailOfCreation(File file) throws IOException, GitAPIException {
        String repoRelativePath = this.pathResolver.relativize(file);
        String authorEmail = "";
        RevWalk walk = this.getGitRevWalk(repoRelativePath, true);
        Iterator iterator = walk.iterator();
        if (iterator.hasNext()) {
            RevCommit commit = (RevCommit)iterator.next();
            authorEmail = this.getAuthorEmailFromCommit(commit);
        }
        walk.dispose();
        return authorEmail;
    }

    private boolean isFileModifiedOrUnstaged(String repoRelativePath) throws GitAPIException {
        Status status = new Git(this.repository).status().addPath(repoRelativePath).call();
        return !status.isClean();
    }

    private RevWalk getGitRevWalk(String repoRelativePath, boolean oldestCommitsFirst) throws IOException {
        DiffConfig diffConfig = (DiffConfig)this.repository.getConfig().get(DiffConfig.KEY);
        RevWalk walk = new RevWalk(this.repository);
        walk.markStart(walk.parseCommit((AnyObjectId)this.repository.resolve("HEAD")));
        walk.setTreeFilter(AndTreeFilter.create(Arrays.asList(PathFilter.create((String)repoRelativePath), FollowFilter.create((String)repoRelativePath, (DiffConfig)diffConfig), TreeFilter.ANY_DIFF)));
        walk.setRevFilter(MaxCountRevFilter.create((int)this.checkCommitsCount));
        walk.setRetainBody(false);
        if (oldestCommitsFirst) {
            walk.sort(RevSort.REVERSE);
        }
        return walk;
    }

    private int getCurrentYear() {
        return GitLookup.toYear(System.currentTimeMillis(), this.timeZone != null ? this.timeZone : DEFAULT_ZONE);
    }

    private int getYearFromCommit(RevCommit commit) {
        switch (this.dateSource) {
            case COMMITER: {
                int epochSeconds = commit.getCommitTime();
                return GitLookup.toYear((long)epochSeconds * 1000L, this.timeZone);
            }
            case AUTHOR: {
                PersonIdent id = commit.getAuthorIdent();
                Date date = id.getWhen();
                return GitLookup.toYear(date.getTime(), id.getTimeZone());
            }
        }
        throw new IllegalStateException("Unexpected " + DateSource.class.getName() + " " + (Object)((Object)this.dateSource));
    }

    private static int toYear(long epochMilliseconds, TimeZone timeZone) {
        Calendar result = Calendar.getInstance(timeZone);
        result.setTimeInMillis(epochMilliseconds);
        return result.get(1);
    }

    private String getAuthorNameFromCommit(RevCommit commit) {
        PersonIdent id = commit.getAuthorIdent();
        return id.getName();
    }

    private String getAuthorEmailFromCommit(RevCommit commit) {
        PersonIdent id = commit.getAuthorIdent();
        return id.getEmailAddress();
    }

    public static enum DateSource {
        AUTHOR,
        COMMITER;

    }
}

