/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.git;

import com.mycila.maven.plugin.license.git.GitLookup;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class GitPropertiesProvider {
    private GitLookup gitLookup;
    public static final String COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY = "license.git.copyrightLastYearMaxCommitsLookup";
    public static final String COPYRIGHT_LAST_YEAR_SOURCE_KEY = "license.git.copyrightLastYearSource";
    public static final String COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY = "license.git.copyrightLastYearTimeZone";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GitLookup getGitLookup(File file, Properties props) throws IOException {
        if (this.gitLookup == null) {
            GitPropertiesProvider gitPropertiesProvider = this;
            synchronized (gitPropertiesProvider) {
                if (this.gitLookup == null) {
                    TimeZone timeZone;
                    String dateSourceString = props.getProperty(COPYRIGHT_LAST_YEAR_SOURCE_KEY, GitLookup.DateSource.AUTHOR.name());
                    GitLookup.DateSource dateSource = GitLookup.DateSource.valueOf(dateSourceString.toUpperCase(Locale.US));
                    String checkCommitsCountString = props.getProperty(COPYRIGHT_LAST_YEAR_MAX_COMMITS_LOOKUP_KEY);
                    int checkCommitsCount = 10;
                    if (checkCommitsCountString != null) {
                        checkCommitsCountString = checkCommitsCountString.trim();
                        checkCommitsCount = Integer.parseInt(checkCommitsCountString);
                    }
                    String tzString = props.getProperty(COPYRIGHT_LAST_YEAR_TIME_ZONE_KEY);
                    switch (dateSource) {
                        case COMMITER: {
                            timeZone = tzString == null ? GitLookup.DEFAULT_ZONE : TimeZone.getTimeZone(tzString);
                            break;
                        }
                        case AUTHOR: {
                            if (tzString != null) {
                                throw new RuntimeException("license.git.copyrightLastYearTimeZone must not be set with license.git.copyrightLastYearSource = " + GitLookup.DateSource.AUTHOR.name() + " because git author name already contrains time zone information.");
                            }
                            timeZone = null;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected " + GitLookup.DateSource.class.getName() + " " + (Object)((Object)dateSource));
                        }
                    }
                    this.gitLookup = new GitLookup(file, dateSource, timeZone, checkCommitsCount);
                }
            }
        }
        return this.gitLookup;
    }
}

