/*
 * Decompiled with CFR 0.152.
 */
package com.ms.square.android.expandabletextview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ms.square.android.expandabletextview.R;

public class ExpandableTextView
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = ExpandableTextView.class.getSimpleName();
    private static final int MAX_COLLAPSED_LINES = 8;
    private static final int DEFAULT_ANIM_DURATION = 300;
    private static final float DEFAULT_ANIM_ALPHA_START = 0.7f;
    protected TextView mTv;
    protected ImageButton mButton;
    private boolean mRelayout;
    private boolean mCollapsed = true;
    private int mCollapsedHeight;
    private int mTextHeightWithMaxLines;
    private int mMaxCollapsedLines;
    private int mMarginBetweenTxtAndBottom;
    private Drawable mExpandDrawable;
    private Drawable mCollapseDrawable;
    private int mAnimationDuration;
    private float mAnimAlphaStart;
    private boolean mAnimating;
    private SparseBooleanArray mCollapsedStatus;
    private int mPosition;

    public ExpandableTextView(Context context) {
        super(context);
    }

    public ExpandableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    @TargetApi(value=11)
    public ExpandableTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public void onClick(View view) {
        if (this.mButton.getVisibility() != 0) {
            return;
        }
        this.mCollapsed = !this.mCollapsed;
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        if (this.mCollapsedStatus != null) {
            this.mCollapsedStatus.put(this.mPosition, this.mCollapsed);
        }
        this.mAnimating = true;
        ExpandCollapseAnimation animation = this.mCollapsed ? new ExpandCollapseAnimation((View)this, this.getHeight(), this.mCollapsedHeight) : new ExpandCollapseAnimation((View)this, this.getHeight(), this.getHeight() + this.mTextHeightWithMaxLines - this.mTv.getHeight());
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart);
            }

            public void onAnimationEnd(Animation animation) {
                ExpandableTextView.this.clearAnimation();
                ExpandableTextView.this.mAnimating = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.clearAnimation();
        this.startAnimation(animation);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mAnimating;
    }

    protected void onFinishInflate() {
        this.findViews();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mRelayout || this.getVisibility() == 8) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.mRelayout = false;
        this.mButton.setVisibility(8);
        this.mTv.setMaxLines(Integer.MAX_VALUE);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mTv.getLineCount() <= this.mMaxCollapsedLines) {
            return;
        }
        this.mTextHeightWithMaxLines = ExpandableTextView.getRealTextViewHeight(this.mTv);
        if (this.mCollapsed) {
            this.mTv.setMaxLines(this.mMaxCollapsedLines);
        }
        this.mButton.setVisibility(0);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mCollapsed) {
            this.mTv.post(new Runnable(){

                @Override
                public void run() {
                    ExpandableTextView.this.mMarginBetweenTxtAndBottom = ExpandableTextView.this.getHeight() - ExpandableTextView.this.mTv.getHeight();
                }
            });
            this.mCollapsedHeight = this.getMeasuredHeight();
        }
    }

    private void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ExpandableTextView);
        this.mMaxCollapsedLines = typedArray.getInt(R.styleable.ExpandableTextView_maxCollapsedLines, 8);
        this.mAnimationDuration = typedArray.getInt(R.styleable.ExpandableTextView_animDuration, 300);
        this.mAnimAlphaStart = typedArray.getFloat(R.styleable.ExpandableTextView_animAlphaStart, 0.7f);
        this.mExpandDrawable = typedArray.getDrawable(R.styleable.ExpandableTextView_expandDrawable);
        this.mCollapseDrawable = typedArray.getDrawable(R.styleable.ExpandableTextView_collapseDrawable);
        if (this.mExpandDrawable == null) {
            this.mExpandDrawable = this.getResources().getDrawable(R.drawable.ic_expand_small_holo_light);
        }
        if (this.mCollapseDrawable == null) {
            this.mCollapseDrawable = this.getResources().getDrawable(R.drawable.ic_collapse_small_holo_light);
        }
        typedArray.recycle();
    }

    private static boolean isPostHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private void findViews() {
        this.mTv = (TextView)this.findViewById(R.id.expandable_text);
        this.mTv.setOnClickListener((View.OnClickListener)this);
        this.mButton = (ImageButton)this.findViewById(R.id.expand_collapse);
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        this.mButton.setOnClickListener((View.OnClickListener)this);
    }

    @TargetApi(value=11)
    private static void applyAlphaAnimation(View view, float alpha) {
        if (ExpandableTextView.isPostHoneycomb()) {
            view.setAlpha(alpha);
        } else {
            AlphaAnimation alphaAnimation = new AlphaAnimation(alpha, alpha);
            alphaAnimation.setDuration(0L);
            alphaAnimation.setFillAfter(true);
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    public void setText(CharSequence text) {
        this.mRelayout = true;
        this.mTv.setText(text);
        this.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
    }

    public void setText(CharSequence text, SparseBooleanArray collapsedStatus, int position) {
        this.mCollapsedStatus = collapsedStatus;
        this.mPosition = position;
        boolean isCollapsed = collapsedStatus.get(position, true);
        this.clearAnimation();
        this.mCollapsed = isCollapsed;
        this.mButton.setImageDrawable(this.mCollapsed ? this.mExpandDrawable : this.mCollapseDrawable);
        this.setText(text);
        this.getLayoutParams().height = -2;
        this.requestLayout();
    }

    public CharSequence getText() {
        if (this.mTv == null) {
            return "";
        }
        return this.mTv.getText();
    }

    private static int getRealTextViewHeight(TextView textView) {
        int textHeight = textView.getLayout().getLineTop(textView.getLineCount());
        int padding = textView.getCompoundPaddingTop() + textView.getCompoundPaddingBottom();
        return textHeight + padding;
    }

    protected class ExpandCollapseAnimation
    extends Animation {
        private final View mTargetView;
        private final int mStartHeight;
        private final int mEndHeight;

        public ExpandCollapseAnimation(View view, int startHeight, int endHeight) {
            this.mTargetView = view;
            this.mStartHeight = startHeight;
            this.mEndHeight = endHeight;
            this.setDuration(ExpandableTextView.this.mAnimationDuration);
        }

        protected void applyTransformation(float interpolatedTime, Transformation t) {
            int newHeight = (int)((float)(this.mEndHeight - this.mStartHeight) * interpolatedTime + (float)this.mStartHeight);
            ExpandableTextView.this.mTv.setMaxHeight(newHeight - ExpandableTextView.this.mMarginBetweenTxtAndBottom);
            if (Float.compare(ExpandableTextView.this.mAnimAlphaStart, 1.0f) != 0) {
                ExpandableTextView.applyAlphaAnimation((View)ExpandableTextView.this.mTv, ExpandableTextView.this.mAnimAlphaStart + interpolatedTime * (1.0f - ExpandableTextView.this.mAnimAlphaStart));
            }
            this.mTargetView.getLayoutParams().height = newHeight;
            this.mTargetView.requestLayout();
        }

        public void initialize(int width, int height, int parentWidth, int parentHeight) {
            super.initialize(width, height, parentWidth, parentHeight);
        }

        public boolean willChangeBounds() {
            return true;
        }
    }
}

