/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.moviejukebox.allocine.model.AbstractBaseInfos;
import com.moviejukebox.allocine.model.FestivalAward;
import com.moviejukebox.allocine.model.MoviePerson;
import com.moviejukebox.allocine.model.Season;
import com.moviejukebox.allocine.model.TvSeries;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TvSeriesInfos
extends AbstractBaseInfos {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="tvseries")
    private TvSeries tvSeries;

    public TvSeries getTvSeries() {
        return this.tvSeries;
    }

    public void setTvSeries(TvSeries tvSeries) {
        this.tvSeries = tvSeries;
    }

    public boolean isValid() {
        if (this.tvSeries == null) {
            return false;
        }
        return this.tvSeries.getCode() > 0;
    }

    public boolean isNotValid() {
        return !this.isValid();
    }

    public int getCode() {
        return this.getCode(this.tvSeries);
    }

    public String getTitle() {
        return this.getTitle(this.tvSeries);
    }

    public String getOriginalTitle() {
        return this.getOriginalTitle(this.tvSeries);
    }

    public int getYearStart() {
        if (this.tvSeries == null) {
            return 0;
        }
        return this.tvSeries.getYearStart();
    }

    public int getYearEnd() {
        if (this.tvSeries == null) {
            return 0;
        }
        return this.tvSeries.getYearEnd();
    }

    public String getReleaseDate() {
        return this.getReleaseDate(this.tvSeries);
    }

    public String getReleaseCountry() {
        return this.getReleaseCountry(this.tvSeries);
    }

    public String getSynopsis() {
        return this.getSynopsis(this.tvSeries);
    }

    public String getSynopsisShort() {
        return this.getSynopsisShort(this.tvSeries);
    }

    public int getUserRating() {
        return this.getUserRating(this.tvSeries);
    }

    public int getPressRating() {
        return this.getPressRating(this.tvSeries);
    }

    public Set<String> getGenres() {
        return this.getGenres(this.tvSeries);
    }

    public Set<String> getNationalities() {
        return this.getNationalities(this.tvSeries);
    }

    public String getOriginalChannel() {
        if (this.tvSeries == null) {
            return null;
        }
        if (this.tvSeries.getOriginalChannel() == null) {
            return null;
        }
        if (this.tvSeries.getOriginalChannel().getChannel() == null) {
            return null;
        }
        return this.tvSeries.getOriginalChannel().getChannel().getName();
    }

    public Set<MoviePerson> getActors() {
        return this.getActors(this.tvSeries);
    }

    public Set<MoviePerson> getDirectors() {
        return this.getDirectors(this.tvSeries);
    }

    public Set<MoviePerson> getWriters() {
        return this.getWriters(this.tvSeries);
    }

    public Set<MoviePerson> getCamera() {
        return this.getCamera(this.tvSeries);
    }

    public Set<MoviePerson> getProducers() {
        return this.getProducers(this.tvSeries);
    }

    public Map<String, Long> getPosters() {
        return this.getPosters(this.tvSeries);
    }

    public int getSeasonCount() {
        if (this.tvSeries == null) {
            return 0;
        }
        return this.tvSeries.getSeasonCount();
    }

    public List<Season> getSeasonList() {
        if (this.tvSeries == null) {
            return Collections.emptyList();
        }
        return this.tvSeries.getSeasonList();
    }

    public final int getSeasonCode(int seasonNumber) {
        for (Season season : this.getSeasonList()) {
            if (season.getSeasonNumber() != seasonNumber) continue;
            return season.getCode();
        }
        return -1;
    }

    public List<FestivalAward> getFestivalAwards() {
        if (this.tvSeries != null) {
            return this.tvSeries.getFestivalAwards();
        }
        return Collections.emptyList();
    }
}

