/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.moviejukebox.allocine.model.AbstractBaseInfos;
import com.moviejukebox.allocine.model.Episode;
import com.moviejukebox.allocine.model.MoviePerson;
import com.moviejukebox.allocine.model.Season;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TvSeasonInfos
extends AbstractBaseInfos {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="season")
    private Season season;

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season season) {
        this.season = season;
    }

    public boolean isValid() {
        if (this.season == null) {
            return false;
        }
        return this.season.getCode() > 0;
    }

    public boolean isNotValid() {
        return !this.isValid();
    }

    public int getCode() {
        if (this.season == null) {
            return -1;
        }
        return this.season.getCode();
    }

    public int getYearStart() {
        if (this.season == null) {
            return 0;
        }
        return this.season.getYearStart();
    }

    public int getYearEnd() {
        if (this.season == null) {
            return 0;
        }
        return this.season.getYearEnd();
    }

    public int getSeasonNumber() {
        if (this.season == null) {
            return -1;
        }
        return this.season.getSeasonNumber();
    }

    public List<Episode> getEpisodeList() {
        if (this.season == null) {
            return Collections.emptyList();
        }
        return this.season.getEpisodeList();
    }

    public Episode getEpisode(int numEpisode) {
        Episode episode = null;
        for (Episode checkEpisode : this.getEpisodeList()) {
            if (checkEpisode.getEpisodeNumberSeason() != numEpisode) continue;
            episode = checkEpisode;
            break;
        }
        return episode;
    }

    public Set<MoviePerson> getActors() {
        return this.getActors(this.season);
    }

    public Set<MoviePerson> getDirectors() {
        return this.getDirectors(this.season);
    }

    public Set<MoviePerson> getWriters() {
        return this.getWriters(this.season);
    }

    public Set<MoviePerson> getCamera() {
        return this.getCamera(this.season);
    }

    public Set<MoviePerson> getProducers() {
        return this.getProducers(this.season);
    }

    public Map<String, Long> getPosters() {
        return this.getPosters(this.season);
    }
}

