/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SwipeDismissListener
implements View.OnTouchListener {
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private ListView mListView;
    private OnDismissCallback mCallback;
    private int mViewWidth = 1;
    private List<PendingDismissData> mPendingDismisses = new ArrayList<PendingDismissData>();
    private int mDismissAnimationRefCount = 0;
    private float mDownX;
    private boolean mSwiping;
    private VelocityTracker mVelocityTracker;
    private int mDownPosition;
    private View mDownView;
    private boolean mPaused;

    public SwipeDismissListener(ListView listView, OnDismissCallback callback) {
        ViewConfiguration vc = ViewConfiguration.get((Context)listView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listView.getContext().getResources().getInteger(0x10E0000);
        this.mListView = listView;
        this.mCallback = callback;
    }

    public void setEnabled(boolean enabled) {
        this.mPaused = !enabled;
    }

    public AbsListView.OnScrollListener makeScrollListener() {
        return new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                SwipeDismissListener.this.setEnabled(scrollState != 1);
            }

            public void onScroll(AbsListView absListView, int i, int i1, int i2) {
            }
        };
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                if (this.mPaused) {
                    return false;
                }
                Rect rect = new Rect();
                int childCount = this.mListView.getChildCount();
                int[] listViewCoords = new int[2];
                this.mListView.getLocationOnScreen(listViewCoords);
                int x = (int)motionEvent.getRawX() - listViewCoords[0];
                int y = (int)motionEvent.getRawY() - listViewCoords[1];
                for (int i = 0; i < childCount; ++i) {
                    View child = this.mListView.getChildAt(i);
                    child.getHitRect(rect);
                    if (!rect.contains(x, y)) continue;
                    this.mDownView = child;
                    break;
                }
                if (this.mDownView != null) {
                    this.mDownX = motionEvent.getRawX();
                    this.mDownPosition = this.mListView.getPositionForView(this.mDownView);
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(motionEvent);
                }
                view.onTouchEvent(motionEvent);
                return true;
            }
            case 1: {
                if (this.mVelocityTracker == null) break;
                float deltaX = motionEvent.getRawX() - this.mDownX;
                this.mVelocityTracker.addMovement(motionEvent);
                this.mVelocityTracker.computeCurrentVelocity(1000);
                float velocityX = Math.abs(this.mVelocityTracker.getXVelocity());
                float velocityY = Math.abs(this.mVelocityTracker.getYVelocity());
                boolean dismiss = false;
                boolean dismissRight = false;
                if (Math.abs(deltaX) > (float)(this.mViewWidth / 2)) {
                    dismiss = true;
                    dismissRight = deltaX > 0.0f;
                } else if ((float)this.mMinFlingVelocity <= velocityX && velocityX <= (float)this.mMaxFlingVelocity && velocityY < velocityX) {
                    dismiss = true;
                    boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
                }
                if (dismiss) {
                    final View downView = this.mDownView;
                    final int downPosition = this.mDownPosition;
                    ++this.mDismissAnimationRefCount;
                    this.mDownView.animate().translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDismissListener.this.performDismiss(downView, downPosition);
                        }
                    });
                } else {
                    this.mDownView.animate().translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
                }
                this.mVelocityTracker = null;
                this.mDownX = 0.0f;
                this.mDownView = null;
                this.mDownPosition = -1;
                this.mSwiping = false;
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mPaused) break;
                this.mVelocityTracker.addMovement(motionEvent);
                float deltaX = motionEvent.getRawX() - this.mDownX;
                if (Math.abs(deltaX) > (float)this.mSlop) {
                    this.mSwiping = true;
                    this.mListView.requestDisallowInterceptTouchEvent(true);
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
                    this.mListView.onTouchEvent(cancelEvent);
                }
                if (!this.mSwiping) break;
                this.mDownView.setTranslationX(deltaX);
                this.mDownView.setAlpha(Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
                return true;
            }
        }
        return false;
    }

    private void performDismiss(final View dismissView, int dismissPosition) {
        final ViewGroup.LayoutParams lp = dismissView.getLayoutParams();
        final int originalHeight = dismissView.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                --SwipeDismissListener.this.mDismissAnimationRefCount;
                if (SwipeDismissListener.this.mDismissAnimationRefCount == 0) {
                    Collections.sort(SwipeDismissListener.this.mPendingDismisses);
                    int[] dismissPositions = new int[SwipeDismissListener.this.mPendingDismisses.size()];
                    for (int i = SwipeDismissListener.this.mPendingDismisses.size() - 1; i >= 0; --i) {
                        dismissPositions[i] = ((PendingDismissData)((SwipeDismissListener)SwipeDismissListener.this).mPendingDismisses.get((int)i)).position;
                    }
                    SwipeDismissListener.this.mCallback.onDismiss(SwipeDismissListener.this.mListView, dismissPositions);
                    for (PendingDismissData pendingDismiss : SwipeDismissListener.this.mPendingDismisses) {
                        pendingDismiss.view.setAlpha(1.0f);
                        pendingDismiss.view.setTranslationX(0.0f);
                        ViewGroup.LayoutParams lp = pendingDismiss.view.getLayoutParams();
                        lp.height = originalHeight;
                        pendingDismiss.view.setLayoutParams(lp);
                    }
                    SwipeDismissListener.this.mPendingDismisses.clear();
                }
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                dismissView.setLayoutParams(lp);
            }
        });
        this.mPendingDismisses.add(new PendingDismissData(dismissPosition, dismissView));
        animator.start();
    }

    class PendingDismissData
    implements Comparable<PendingDismissData> {
        public int position;
        public View view;

        public PendingDismissData(int position, View view) {
            this.position = position;
            this.view = view;
        }

        @Override
        public int compareTo(PendingDismissData other) {
            return other.position - this.position;
        }
    }

    public static interface OnDismissCallback {
        public void onDismiss(ListView var1, int[] var2);
    }
}

