/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.monitorjbl.json.DefaultView;
import com.monitorjbl.json.JsonResultRetriever;
import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.JsonViewResponseProcessor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class JsonViewReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonViewReturnValueHandler.class);
    private final HandlerMethodReturnValueHandler delegate;
    private final DefaultView defaultView;

    public JsonViewReturnValueHandler(List<HttpMessageConverter<?>> converters, DefaultView defaultView) {
        this.delegate = new JsonViewResponseProcessor(converters);
        this.defaultView = defaultView;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object val = returnValue;
        if (JsonResultRetriever.hasValue()) {
            val = JsonResultRetriever.retrieve();
            log.debug("Found [" + ((JsonView)val).getValue().getClass() + "] to serialize");
        } else {
            JsonView view = this.defaultView.getMatch(val);
            if (view != null) {
                val = view;
                log.debug("Default view found for " + val.getClass().getCanonicalName() + ", applied before serialization");
            } else {
                log.debug("No JsonView found for thread, using returned value");
            }
        }
        this.delegate.handleReturnValue(val, returnType, mavContainer, webRequest);
    }
}

