/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class LineReader
implements Iterable<String>,
Iterator<String> {
    final BufferedReader _in;
    private String _next = null;

    public LineReader(String filename) throws IOException {
        this(new File(filename));
    }

    public LineReader(File f) throws IOException {
        this(LineReader._open(f));
    }

    public LineReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public LineReader(Reader r) {
        this(new BufferedReader(r));
    }

    public LineReader(BufferedReader in) {
        this._in = in;
    }

    @Override
    public String next() {
        if (this._next != null) {
            String s = this._next;
            this._next = null;
            return s;
        }
        try {
            return this._in.readLine();
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't read", ioe);
        }
    }

    @Override
    public boolean hasNext() {
        if (this._next != null) {
            return true;
        }
        try {
            this._next = this._in.readLine();
        }
        catch (IOException ioe) {
            throw new RuntimeException("can't read", ioe);
        }
        return this._next != null;
    }

    @Override
    public void remove() {
        throw new RuntimeException("you are stupid");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    private static InputStream _open(File f) throws IOException {
        InputStream in = new FileInputStream(f);
        if (f.getName().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }
}

