/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.io;

import com.mongodb.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static void touch(File f) throws IOException {
        if (f.createNewFile()) {
            return;
        }
        f.setLastModified(System.currentTimeMillis());
    }

    public static String toString(File f) {
        return FileUtil.clean(f.toString());
    }

    public static String clean(String s) {
        if (s.contains("\\") || s.contains(":")) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    c = '/';
                } else if (c == ':') {
                    c = '_';
                }
                buf.append(c);
            }
            s = buf.toString();
        }
        return s;
    }

    public static void deleteDirectory(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                FileUtil.deleteDirectory(c);
            }
        }
        f.delete();
    }

    public static void add(ZipOutputStream out, String path, File f) throws IOException {
        FileUtil.add(out, path, new FileInputStream(f), f.lastModified());
    }

    public static void add(ZipOutputStream out, String path, InputStream data, long lastModified) throws IOException {
        path = path.replace('\\', '/');
        ZipEntry entry = new ZipEntry(path);
        entry.setTime(lastModified);
        out.putNextEntry(entry);
        StreamUtil.pipe(data, out);
    }
}

