/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBAddress;
import com.mongodb.DBPort;
import com.mongodb.MongoInternalException;
import com.mongodb.util.SimplePool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;

class DBPortPool
extends SimplePool<DBPort> {
    public final long _maxWaitTime = 120000L;
    private static final Map<InetSocketAddress, DBPortPool> _pools = Collections.synchronizedMap(new HashMap());
    private final Semaphore _waitingSem;
    final InetSocketAddress _addr;
    boolean _everWorked = false;

    static DBPortPool get(DBAddress addr) {
        return DBPortPool.get(addr.getSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DBPortPool get(InetSocketAddress addr) {
        DBPortPool p = _pools.get(addr);
        if (p != null) {
            return p;
        }
        Map<InetSocketAddress, DBPortPool> map = _pools;
        synchronized (map) {
            p = _pools.get(addr);
            if (p != null) {
                return p;
            }
            p = new DBPortPool(addr);
            _pools.put(addr, p);
        }
        return p;
    }

    DBPortPool(InetSocketAddress addr) {
        super("DBPortPool-" + addr.toString(), Bytes.CONNECTIONS_PER_HOST, Bytes.CONNECTIONS_PER_HOST);
        this._addr = addr;
        this._waitingSem = new Semaphore(Bytes.CONNECTIONS_PER_HOST * 5);
    }

    protected long memSize(DBPort p) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new NoMoreConnection();
        }
        try {
            port = (DBPort)this.get(120000L);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new NoMoreConnection();
        }
        return port;
    }

    void gotError(Exception e) {
        if (e instanceof ClosedByInterruptException || e instanceof InterruptedException) {
            return;
        }
        Bytes.LOGGER.log(Level.INFO, "emptying DBPortPool b/c of error", e);
        this.clear();
    }

    @Override
    public boolean ok(DBPort t) {
        return this._addr.equals(t._addr);
    }

    @Override
    protected DBPort createNew() throws MongoInternalException {
        try {
            return new DBPort(this._addr, this);
        }
        catch (IOException ioe) {
            throw new MongoInternalException("can't create port to:" + this._addr, ioe);
        }
    }

    public static class NoMoreConnection
    extends MongoInternalException {
        NoMoreConnection() {
            super("No more DB Connections");
        }
    }
}

