/*
 * Decompiled with CFR 0.152.
 */
package com.monator.mail.templating.template;

import com.monator.mail.templating.exception.MailSendingExcpetion;
import com.monator.mail.templating.template.MailTemplate;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class FreeMarkerMailTemplate
implements MailTemplate {
    private Configuration cfg = new Configuration(Configuration.getVersion());

    public FreeMarkerMailTemplate() {
        this.cfg.setClassForTemplateLoading(this.getClass(), "/META-INF/resources");
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
    }

    protected abstract String getTemplatePath();

    @Override
    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    @Override
    public String render(Map<String, Object> data) {
        String templatePath = this.getTemplatePath();
        StringWriter out = new StringWriter();
        try {
            Template temp = this.cfg.getTemplate(templatePath);
            temp.process(data, (Writer)out);
        }
        catch (TemplateException | IOException e) {
            throw new MailSendingExcpetion(e);
        }
        return ((Object)out).toString();
    }
}

