/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.util;

import java.nio.ByteBuffer;
import java.util.List;

public class CRC64 {
    public static final long[] LOOKUP_TABLE = new long[]{0L, 8851949072701294969L, -742845928306961678L, -8113074920216421493L, -4595671135093148017L, -4980816554654154762L, 3857338458010461309L, 5715195658523061508L, -6113376234570973579L, -3318980867503589620L, 6816212484437830791L, 2612226237385041406L, 7714676916020922618L, 1281407202545942915L, -7016352756663428600L, -1983667824504351887L, 9009731685717012353L, 563108230357313272L, -8595086165142045325L, -981663343647329270L, -4814319104833890034L, -4041863567026532233L, 5224452474770082812L, 3627802401766982277L, -3017390241667706380L, -5982922944867788659L, 2562814405091885830L, 6433535930597116543L, 1592294032496338811L, 7836410910743637506L, -2042356677977557623L, -7390293033759687440L, -427280702275526910L, -9166638614987581829L, 1126216460714626544L, 8464919223366468745L, 4190910634541279629L, 4679640014836523252L, -3487480918944875649L, -5385871547969572346L, 5852729821509460343L, 3161916214005835790L, -6590469041452534907L, -2427014021741364484L, -7997839124169385992L, -1451980451876168063L, 7255604803533964554L, 2191395843288271987L, -8711930575662698365L, -161723297007453702L, 8262382231073956465L, 608425843627928328L, 5125628810183771660L, 4465764294926438261L, -5579672212515318530L, -4014548506208526969L, 3184588064992677622L, 6262709589572306831L, -2773922252222276604L, -6676167943253338755L, -1438609211103119239L, -7579144467225874176L, 1853769023980628619L, 7161174014982448114L, -2343320148755206801L, -6511454690488900586L, 3083341959784644509L, 5769757520242456292L, 2252432921429253088L, 7321251034957484697L, -1516905626976614126L, -8058436620964003733L, 8381821269082559258L, 1047727658635319907L, -9087464044036505112L, -343778454096557935L, -5446308276092574315L, -3552597168020853524L, 4745161141923116903L, 4252033715651608094L, -6741284430690630930L, -2834359218710656105L, 6323832428011671580L, 3250108949404244325L, 7082685524280996961L, 1770671381070249240L, -7495641911945140589L, -1359434333054603286L, 674072313427442843L, 8323419547594995170L, -222320551145787799L, -8776855508102797552L, -3935534466641622508L, -5495978650921565331L, 4382791686576543974L, 5047054248884015519L, 2696289253709771373L, 6895947823530343188L, -3396904503390642017L, -6195909022666954266L, -1921979611561638686L, -6950266497748513381L, 1216851687255856656L, 7654800921679748969L, -8195486453342008296L, -820859414382410399L, 8931528589852876522L, 84259039178430355L, 5655163293556783767L, 3792978414742418414L, -4914609589448824731L, -4534073323166293732L, 6369176129985355244L, 2502782282785952917L, -5921324894564937954L, -2951183038082316697L, -7468306826918024349L, -2124768518181707238L, 7920669638525335953L, 1671873238255513832L, -915577327403375719L, -8533398194874357024L, 503231997654823275L, 8945175932061546514L, 3707538047961257238L, 5308515798192249967L, -4124396043744655388L, -4892242429347410275L, -7661587058870466123L, -1192077443213672244L, 6925536469308201799L, 1928669229005230654L, 6166683919569289018L, 3408106242218915395L, -6907229033224639032L, -2667002881850940239L, 4504865842858506176L, 4925828954283753145L, -3804242003794582222L, -5625859302133486517L, -91027543915855537L, -8906736712287582154L, 796147016248169405L, 8202193697865996996L, -1683101535544433100L, -7891400724083364019L, 2095455317270639814L, 7479631577382337983L, 2926364910754730171L, 5928137516128508354L, -2509515504350199223L, -6344419337991189712L, 4867406749023426625L, 4131191115536978232L, -5315266574900639053L, -3682798812180528182L, -8956421789863317810L, -473980642647513161L, 8504067431303216188L, 926884511990314309L, 8051711962477172407L, 1541670979892322254L, -7346060597066464187L, -2245611732491203268L, -5799079217686208456L, -3072025708008887999L, 6500217898808488650L, 2372580570961558451L, -4281373025147557694L, -4733862501121891909L, 3541342762140498480L, 5475551080882205513L, 337036156713721421L, 9112211761281881908L, -1072554861787525953L, -8375017722257553978L, 1348144626854885686L, 7524919785159454799L, -1799904978519561276L, -7071492277665275203L, -3274830414739877959L, -6317134249602496832L, 2827581646778391883L, 6766067242130363442L, -5071758167665440957L, -4376075960543867334L, 5489218623395763633L, 3960334819262667976L, 8765583373153087948L, 251615998827411637L, -8352635575941520578L, -662861498787124665L, 5392578507419542746L, 3462768234654100899L, -4654848426648865240L, -4197679429721555119L, -8435614942565739947L, -1137479759323604180L, 9177858264896848039L, 398073508124084702L, -2162109211042833745L, -7266885753923922986L, 1463182455377365085L, 7968614284679676196L, 2433703374511713312L, 6565738749404456281L, -3137142230350053678L, -5859516218004850773L, 4025855981238586203L, 5550341738321543714L, -4436512653762848343L, -5136874382911270704L, -583686894003798572L, -8269133292856429395L, 168518078356860710L, 8687094605961012831L, -7136417486595984082L, -1860502510218052521L, 7585956829484836828L, 1413790823389195941L, 6687492953022055329L, 2744609311697881816L, -6233440411522313901L, -3195816097608607702L, -5708391813738841128L, -3882165362121461087L, 5005564565571905834L, 4588929132448424019L, 8142317431333358935L, 731591227688682542L, -8840650729859080283L, -29339608537491748L, 2012927990619293101L, 7005115709973351636L, -1270091202558503073L, -7743998864187498970L, -2605404796658879710L, -6841021795823650213L, 3343746476511027664L, 6106651831093618857L, -3616591881864522663L, -5253668796789236448L, 4071158715666679467L, 4803046671925235666L, 1006463995309646550L, 8588326435575524271L, -556392209586458588L, -9034435310825997987L, 7415076095922514476L, 2035579357833339733L, -7829712477325051682L, -1617015241740308057L, -6422342938991125341L, -2592048258632673830L, 6012200567359213137L, 3006100283679606568L};

    public static long crc64(byte[] bytes) {
        return CRC64.crc64(bytes, 0, bytes.length);
    }

    public static long crc64(byte[] bytes, long sum) {
        return CRC64.crc64(bytes, 0, bytes.length, sum);
    }

    public static long crc64(ByteBuffer buf) {
        return CRC64.crc64(buf, 0L);
    }

    public static long crc64(ByteBuffer buf, long sum) {
        return CRC64.crc64(buf.array(), buf.position(), buf.limit(), sum);
    }

    public static long crc64(List<ByteBuffer> list) {
        long sum = 0L;
        for (ByteBuffer buf : list) {
            sum = CRC64.crc64(buf, sum);
        }
        return sum;
    }

    public static long crc64(byte b, long sum) {
        return sum >>> 8 ^ LOOKUP_TABLE[((int)sum ^ b) & 0xFF];
    }

    public static long crc64(byte[] bytes, int start, int length) {
        return CRC64.crc64(bytes, start, length, 0L);
    }

    public static long crc64(byte[] bytes, int start, int length, long sum) {
        for (int i = start; i < start + length; ++i) {
            sum = CRC64.crc64(bytes[i], sum);
        }
        return sum;
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
    }
}

