/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.MaxLen;
import com.moilioncircle.redis.replicator.cmd.impl.XAddCommand;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import com.moilioncircle.redis.replicator.util.Strings;
import java.util.Objects;

public class XAddParser
implements CommandParser<XAddCommand> {
    @Override
    public XAddCommand parse(Object[] command) {
        int idx = 1;
        byte[] key = CommandParsers.toBytes(command[idx]);
        MaxLen maxLen = null;
        if (Strings.isEquals(CommandParsers.toRune(command[++idx]), "MAXLEN")) {
            boolean approximation = false;
            if (Objects.equals(CommandParsers.toRune(command[++idx]), "~")) {
                approximation = true;
                ++idx;
            } else if (Objects.equals(CommandParsers.toRune(command[idx]), "=")) {
                ++idx;
            }
            long count = CommandParsers.toLong(command[idx]);
            ++idx;
            maxLen = new MaxLen(approximation, count);
        }
        byte[] id = CommandParsers.toBytes(command[idx]);
        ++idx;
        ByteArrayMap fields = new ByteArrayMap();
        while (idx < command.length) {
            byte[] field = CommandParsers.toBytes(command[idx]);
            byte[] value = ++idx == command.length ? null : CommandParsers.toBytes(command[idx]);
            ++idx;
            fields.put(field, value);
        }
        return new XAddCommand(key, maxLen, id, fields);
    }
}

