/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.module;

import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.util.ByteArray;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRdbModuleParser {
    protected static final Log logger = LogFactory.getLog(DefaultRdbModuleParser.class);
    private final RedisInputStream in;
    private final BaseRdbParser parser;

    public DefaultRdbModuleParser(RedisInputStream in) {
        this.in = in;
        this.parser = new BaseRdbParser(in);
    }

    public RedisInputStream inputStream() {
        return this.in;
    }

    @Deprecated
    public long loadSigned() throws IOException {
        return this.loadSigned(1);
    }

    @Deprecated
    public long loadUnSigned() throws IOException {
        return this.loadSigned(1);
    }

    @Deprecated
    public BigInteger loadUnsigned() throws IOException {
        return this.loadUnsigned(1);
    }

    @Deprecated
    public String loadString() throws IOException {
        return this.loadString(1);
    }

    @Deprecated
    public byte[] loadStringBuffer() throws IOException {
        return this.loadStringBuffer(1);
    }

    @Deprecated
    public double loadDouble() throws IOException {
        return this.loadDouble(1);
    }

    @Deprecated
    public float loadFloat() throws IOException {
        return this.loadFloat(1);
    }

    public long loadSigned(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 2L) {
            throw new UnsupportedOperationException("Error loading signed or unsigned long from RDB.");
        }
        return this.parser.rdbLoadLen().len;
    }

    public BigInteger loadUnsigned(int version) throws IOException {
        byte[] ary = new byte[8];
        long value = this.loadSigned(version);
        for (int i = 0; i < 8; ++i) {
            ary[7 - i] = (byte)(value >>> (i << 3) & 0xFFL);
        }
        return new BigInteger(1, ary);
    }

    public String loadString(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 5L) {
            throw new UnsupportedOperationException("Error loading string from RDB.");
        }
        ByteArray bytes = this.parser.rdbGenericLoadStringObject(0);
        return new String(bytes.first(), StandardCharsets.UTF_8);
    }

    public byte[] loadStringBuffer(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 5L) {
            throw new UnsupportedOperationException("Error loading string from RDB.");
        }
        ByteArray bytes = this.parser.rdbGenericLoadStringObject(2);
        return bytes.first();
    }

    public double loadDouble(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 4L) {
            throw new UnsupportedOperationException("Error loading double from RDB.");
        }
        return this.parser.rdbLoadBinaryDoubleValue();
    }

    public float loadFloat(int version) throws IOException {
        long opcode;
        if (version == 2 && (opcode = this.parser.rdbLoadLen().len) != 3L) {
            throw new UnsupportedOperationException("Error loading float from RDB.");
        }
        return this.parser.rdbLoadBinaryFloatValue();
    }
}

