/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.datatype;

import java.io.Serializable;

public class ZSetEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String element;
    private double score;
    private byte[] rawElement;

    public ZSetEntry() {
    }

    public ZSetEntry(String element, double score) {
        this(element, score, null);
    }

    public ZSetEntry(String element, double score, byte[] rawElement) {
        this.element = element;
        this.score = score;
        this.rawElement = rawElement;
    }

    public String getElement() {
        return this.element;
    }

    public double getScore() {
        return this.score;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public byte[] getRawElement() {
        return this.rawElement;
    }

    public void setRawElement(byte[] rawElement) {
        this.rawElement = rawElement;
    }

    public String toString() {
        return "[" + this.element + ", " + this.score + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZSetEntry zSetEntry = (ZSetEntry)o;
        if (Double.compare(zSetEntry.score, this.score) != 0) {
            return false;
        }
        return this.element.equals(zSetEntry.element);
    }

    public int hashCode() {
        int result = this.element.hashCode();
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

