/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockTopic;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DestinationManager
implements Serializable {
    private ConcurrentMap<String, MockQueue> queues = new ConcurrentHashMap<String, MockQueue>();
    private ConcurrentMap<String, MockTopic> topics = new ConcurrentHashMap<String, MockTopic>();

    public MockQueue createQueue(String name) {
        MockQueue queue = new MockQueue(name);
        MockQueue orig = this.queues.putIfAbsent(name, queue);
        return orig == null ? queue : orig;
    }

    public void removeQueue(String name) {
        this.queues.remove(name);
    }

    public MockQueue getQueue(String name) {
        return this.createQueue(name);
    }

    public MockTopic createTopic(String name) {
        MockTopic topic = new MockTopic(name);
        MockTopic orig = this.topics.putIfAbsent(name, topic);
        return orig == null ? topic : orig;
    }

    public void removeTopic(String name) {
        this.topics.remove(name);
    }

    public MockTopic getTopic(String name) {
        return this.createTopic(name);
    }

    public boolean existsTopic(String topicName) {
        return this.topics.containsKey(topicName);
    }

    public boolean existsQueue(String queueName) {
        return this.queues.containsKey(queueName);
    }
}

