/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.GenericTransmissionManager;
import com.mockrunner.jms.MessageManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.jms.TransmissionManagerWrapper;
import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockQueue;
import com.mockrunner.mock.jms.MockTemporaryQueue;
import com.mockrunner.mock.jms.MockTemporaryTopic;
import com.mockrunner.mock.jms.MockTopic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockSession
implements Session,
Serializable {
    private static final Log logger = LogFactory.getLog(MockSession.class);
    private MockConnection connection;
    private QueueTransmissionManager queueTransManager;
    private TopicTransmissionManager topicTransManager;
    private GenericTransmissionManager genericTransManager;
    private TransmissionManagerWrapper transManager;
    private MessageManager messageManager;
    private MessageListener messageListener;
    private List tempQueues;
    private List tempTopics;
    private Set queues;
    private Set topics;
    private boolean transacted;
    private int acknowledgeMode;
    private int numberCommits;
    private int numberRollbacks;
    private boolean recovered;
    private boolean closed;

    public MockSession(MockConnection connection, boolean transacted, int acknowledgeMode) {
        this.connection = connection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.queueTransManager = new QueueTransmissionManager(connection, this);
        this.topicTransManager = new TopicTransmissionManager(connection, this);
        this.genericTransManager = new GenericTransmissionManager(connection, this);
        this.transManager = new TransmissionManagerWrapper(this.queueTransManager, this.topicTransManager, this.genericTransManager);
        this.messageManager = new MessageManager();
        this.tempQueues = new ArrayList();
        this.tempTopics = new ArrayList();
        this.queues = new HashSet();
        this.topics = new HashSet();
        this.messageListener = null;
        this.numberCommits = 0;
        this.numberRollbacks = 0;
        this.recovered = false;
        this.closed = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Created new mock session");
        }
    }

    public QueueTransmissionManager getQueueTransmissionManager() {
        return this.queueTransManager;
    }

    public TopicTransmissionManager getTopicTransmissionManager() {
        return this.topicTransManager;
    }

    public GenericTransmissionManager getGenericTransmissionManager() {
        return this.genericTransManager;
    }

    public TransmissionManagerWrapper getTransmissionManager() {
        return this.getTransmissionManagerWrapper();
    }

    public TransmissionManagerWrapper getTransmissionManagerWrapper() {
        return this.transManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public List getTemporaryQueueList() {
        return Collections.unmodifiableList(this.tempQueues);
    }

    public MockTemporaryQueue getTemporaryQueue(int index) {
        if (this.tempQueues.size() <= index || index < 0) {
            return null;
        }
        return (MockTemporaryQueue)this.tempQueues.get(index);
    }

    public List getTemporaryTopicList() {
        return Collections.unmodifiableList(this.tempTopics);
    }

    public MockTemporaryTopic getTemporaryTopic(int index) {
        if (this.tempTopics.size() <= index || index < 0) {
            return null;
        }
        return (MockTemporaryTopic)this.tempTopics.get(index);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isRecovered() {
        return this.recovered;
    }

    public boolean isCommitted() {
        return this.numberCommits > 0;
    }

    public int getNumberCommits() {
        return this.numberCommits;
    }

    public boolean isRolledBack() {
        return this.numberRollbacks > 0;
    }

    public int getNumberRollbacks() {
        return this.numberRollbacks;
    }

    public boolean isAutoAcknowledge() {
        return this.acknowledgeMode != 2;
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.getTransacted()) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public boolean getTransacted() throws JMSException {
        this.connection.throwJMSException();
        return this.transacted;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.createObjectMessage(null);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.connection.throwJMSException();
        return this.createTextMessage(null);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.connection.throwJMSException();
        return this.getMessageManager().createTextMessage(text);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.connection.throwJMSException();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.connection.throwJMSException();
        this.messageListener = messageListener;
    }

    public void run() {
    }

    public void commit() throws JMSException {
        this.connection.throwJMSException();
        ++this.numberCommits;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Mock session commit");
        }
    }

    public void rollback() throws JMSException {
        this.connection.throwJMSException();
        this.recover();
        ++this.numberRollbacks;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Mock session rollback");
        }
    }

    public void close() throws JMSException {
        this.connection.throwJMSException();
        if (this.getTransacted() && !this.isCommitted()) {
            this.rollback();
        }
        this.getQueueTransmissionManager().closeAll();
        this.getTopicTransmissionManager().closeAll();
        this.getGenericTransmissionManager().closeAll();
        this.removeSessionFromDestinations(this.tempQueues);
        this.removeSessionFromDestinations(this.tempTopics);
        this.removeSessionFromDestinations(this.queues);
        this.removeSessionFromDestinations(this.topics);
        this.queues.clear();
        this.topics.clear();
        this.closed = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Mock session closed");
        }
    }

    private void removeSessionFromDestinations(Collection destinations) {
        for (Object currentDestination : destinations) {
            if (!(currentDestination instanceof MockDestination)) continue;
            ((MockDestination)currentDestination).removeSession(this);
        }
    }

    public void recover() throws JMSException {
        this.connection.throwJMSException();
        this.recovered = true;
    }

    public void unsubscribe(String name) throws JMSException {
        this.getConnection().throwJMSException();
        this.topicTransManager.removeTopicDurableSubscriber(name);
    }

    public Queue createQueue(String name) throws JMSException {
        this.getConnection().throwJMSException();
        MockQueue queue = this.getConnection().getDestinationManager().getQueue(name);
        if (null == queue) {
            throw new JMSException("Queue with name " + name + " not found");
        }
        this.addSessionToQueue(queue);
        return queue;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.getConnection().throwJMSException();
        MockTemporaryQueue queue = new MockTemporaryQueue();
        this.tempQueues.add(queue);
        this.addSessionToQueue(queue);
        return queue;
    }

    public Topic createTopic(String name) throws JMSException {
        this.getConnection().throwJMSException();
        MockTopic topic = this.getConnection().getDestinationManager().getTopic(name);
        if (null == topic) {
            throw new JMSException("Topic with name " + name + " not found");
        }
        this.addSessionToTopic(topic);
        return topic;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.getConnection().throwJMSException();
        MockTemporaryTopic topic = new MockTemporaryTopic();
        this.tempTopics.add(topic);
        this.addSessionToTopic(topic);
        return topic;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createConsumer(destination, null);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createConsumer(destination, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (null == destination) {
            throw new IllegalArgumentException("destination must not be null");
        }
        this.getConnection().throwJMSException();
        if (destination instanceof MockQueue) {
            this.addSessionToQueue((Queue)destination);
            return this.getQueueTransmissionManager().createQueueReceiver((MockQueue)destination, messageSelector);
        }
        if (destination instanceof MockTopic) {
            this.addSessionToTopic((Topic)destination);
            return this.getTopicTransmissionManager().createTopicSubscriber((MockTopic)destination, messageSelector, noLocal);
        }
        throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.getConnection().throwJMSException();
        if (null == destination) {
            return this.createProducerForNullDestination();
        }
        if (destination instanceof MockQueue) {
            this.addSessionToQueue((Queue)destination);
            return this.getQueueTransmissionManager().createQueueSender((MockQueue)destination);
        }
        if (destination instanceof MockTopic) {
            this.addSessionToTopic((Topic)destination);
            return this.getTopicTransmissionManager().createTopicPublisher((MockTopic)destination);
        }
        throw new InvalidDestinationException("destination must be an instance of MockQueue or MockTopic");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.getConnection().throwJMSException();
        if (!(queue instanceof MockQueue)) {
            throw new InvalidDestinationException("queue must be an instance of MockQueue");
        }
        this.addSessionToQueue(queue);
        return this.queueTransManager.createQueueBrowser((MockQueue)queue, messageSelector);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.getConnection().throwJMSException();
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.getConnection().throwJMSException();
        if (!(topic instanceof MockTopic)) {
            throw new InvalidDestinationException("topic must be an instance of MockTopic");
        }
        this.addSessionToTopic(topic);
        return this.topicTransManager.createDurableTopicSubscriber((MockTopic)topic, name, messageSelector, noLocal);
    }

    protected MockConnection getConnection() {
        return this.connection;
    }

    public void addSessionToQueue(Queue queue) {
        if (queue instanceof MockQueue) {
            ((MockQueue)queue).addSession(this);
            this.queues.add(queue);
        }
    }

    public void addSessionToTopic(Topic topic) {
        if (topic instanceof MockTopic) {
            ((MockTopic)topic).addSession(this);
            this.topics.add(topic);
        }
    }

    protected MessageProducer createProducerForNullDestination() {
        return this.getGenericTransmissionManager().createMessageProducer();
    }
}

