/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.jms.ConfigurationManager;
import com.mockrunner.jms.DestinationManager;
import com.mockrunner.mock.jms.MockConnectionConsumer;
import com.mockrunner.mock.jms.MockConnectionMetaData;
import com.mockrunner.mock.jms.MockSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockConnection
implements Connection,
Serializable {
    private static final Log logger = LogFactory.getLog(MockConnection.class);
    private ConnectionMetaData metaData = new MockConnectionMetaData();
    private List sessions;
    private String clientId;
    private boolean started = false;
    private boolean closed = false;
    private ExceptionListener listener;
    private JMSException exception = null;
    private DestinationManager destinationManager;
    private ConfigurationManager configurationManager;
    private String userName;
    private String password;

    public MockConnection(DestinationManager destinationManager, ConfigurationManager configurationManager) {
        this(destinationManager, configurationManager, null, null);
    }

    public MockConnection(DestinationManager destinationManager, ConfigurationManager configurationManager, String userName, String password) {
        this.destinationManager = destinationManager;
        this.configurationManager = configurationManager;
        this.sessions = new ArrayList();
        this.userName = userName;
        this.password = password;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Created new mock connection");
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public DestinationManager getDestinationManager() {
        return this.destinationManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public List getSessionList() {
        return Collections.unmodifiableList(this.sessions);
    }

    public MockSession getSession(int index) {
        if (this.sessions.size() <= index || index < 0) {
            return null;
        }
        return (MockSession)this.sessions.get(index);
    }

    public void setJMSException(JMSException exception) {
        this.exception = exception;
    }

    public void throwJMSException() throws JMSException {
        if (null == this.exception) {
            return;
        }
        JMSException tempException = this.exception;
        this.exception = null;
        throw tempException;
    }

    public void callExceptionListener() {
        JMSException tempException = this.exception;
        this.exception = null;
        this.callExceptionListener(tempException);
    }

    public void callExceptionListener(JMSException exception) {
        if (this.listener != null && exception != null) {
            this.listener.onException(exception);
        }
    }

    public void setMetaData(ConnectionMetaData metaData) {
        this.metaData = metaData;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.throwJMSException();
        MockSession session = new MockSession(this, transacted, acknowledgeMode);
        this.sessions().add(session);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.throwJMSException();
        return new MockConnectionConsumer(this, sessionPool);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.throwJMSException();
        return this.metaData;
    }

    public String getClientID() throws JMSException {
        this.throwJMSException();
        return this.clientId;
    }

    public void setClientID(String clientId) throws JMSException {
        this.throwJMSException();
        this.clientId = clientId;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.throwJMSException();
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.throwJMSException();
        this.listener = listener;
    }

    public void start() throws JMSException {
        this.throwJMSException();
        this.started = true;
    }

    public void stop() throws JMSException {
        this.throwJMSException();
        this.started = false;
    }

    public void close() throws JMSException {
        this.throwJMSException();
        for (Object session1 : this.sessions) {
            Session session = (Session)session1;
            session.close();
        }
        this.closed = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Closed mock connection");
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.isStarted();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected List sessions() {
        return this.sessions;
    }
}

