/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.jms.GenericTransmissionManager;
import com.mockrunner.jms.QueueTransmissionManager;
import com.mockrunner.jms.TopicTransmissionManager;
import com.mockrunner.mock.jms.MockMessageConsumer;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockTopicPublisher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TransmissionManagerWrapper
implements Serializable {
    private QueueTransmissionManager queueManager;
    private TopicTransmissionManager topicManager;
    private GenericTransmissionManager genericManager;

    public TransmissionManagerWrapper(QueueTransmissionManager queueManager, TopicTransmissionManager topicManager, GenericTransmissionManager genericManager) {
        this.queueManager = queueManager;
        this.topicManager = topicManager;
        this.genericManager = genericManager;
    }

    public QueueTransmissionManager getQueueTransmissionManager() {
        return this.queueManager;
    }

    public TopicTransmissionManager getTopicTransmissionManager() {
        return this.topicManager;
    }

    public GenericTransmissionManager getGenericTransmissionManager() {
        return this.genericManager;
    }

    public MockMessageProducer getMessageProducer(int index) {
        List messageProducerList = this.getMessageProducerList();
        if (messageProducerList.size() <= index || index < 0) {
            return null;
        }
        return (MockMessageProducer)messageProducerList.get(index);
    }

    public List getMessageProducerList() {
        ArrayList resultList = new ArrayList();
        resultList.addAll(this.queueManager.getQueueSenderList());
        resultList.addAll(this.topicManager.getTopicPublisherList());
        resultList.addAll(this.genericManager.getMessageProducerList());
        return resultList;
    }

    public List getQueueSenderList() {
        ArrayList resultList = new ArrayList();
        resultList.addAll(this.queueManager.getQueueSenderList());
        List genericList = this.genericManager.getMessageProducerList();
        for (Object next : genericList) {
            if (!(next instanceof MockQueueSender)) continue;
            resultList.add(next);
        }
        return resultList;
    }

    public MockQueueSender getQueueSender(int index) {
        List queueSenderList = this.getQueueSenderList();
        if (queueSenderList.size() <= index || index < 0) {
            return null;
        }
        return (MockQueueSender)queueSenderList.get(index);
    }

    public List getTopicPublisherList() {
        ArrayList resultList = new ArrayList();
        resultList.addAll(this.topicManager.getTopicPublisherList());
        List genericList = this.genericManager.getMessageProducerList();
        for (Object next : genericList) {
            if (!(next instanceof MockTopicPublisher)) continue;
            resultList.add(next);
        }
        return resultList;
    }

    public MockTopicPublisher getTopicPublisher(int index) {
        List topicPublisherList = this.getTopicPublisherList();
        if (topicPublisherList.size() <= index || index < 0) {
            return null;
        }
        return (MockTopicPublisher)topicPublisherList.get(index);
    }

    public MockMessageConsumer getMessageConsumer(int index) {
        List messageConsumerList = this.getMessageConsumerList();
        if (messageConsumerList.size() <= index || index < 0) {
            return null;
        }
        return (MockMessageConsumer)messageConsumerList.get(index);
    }

    public List getMessageConsumerList() {
        ArrayList resultList = new ArrayList();
        resultList.addAll(this.queueManager.getQueueReceiverList());
        resultList.addAll(this.topicManager.getTopicSubscriberList());
        resultList.addAll(this.topicManager.getDurableTopicSubscriberMap().values());
        return resultList;
    }
}

