/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jms;

import com.mockrunner.mock.jms.MockConnection;
import com.mockrunner.mock.jms.MockMessageProducer;
import com.mockrunner.mock.jms.MockQueueSender;
import com.mockrunner.mock.jms.MockSession;
import com.mockrunner.mock.jms.MockTopicPublisher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public class GenericTransmissionManager
implements Serializable {
    private MockConnection connection;
    private MockSession session;
    private List messageProducerList;

    public GenericTransmissionManager(MockConnection connection, MockSession session) {
        this.connection = connection;
        this.session = session;
        this.messageProducerList = new ArrayList();
    }

    public void closeAll() {
        this.closeAllMessageProducers();
    }

    public void closeAllMessageProducers() {
        for (Object aMessageProducerList : this.messageProducerList) {
            MessageProducer producer = (MessageProducer)aMessageProducerList;
            try {
                producer.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public MockMessageProducer createMessageProducer() {
        MockMessageProducer producer = new MockMessageProducer(this.connection, this.session, null);
        this.messageProducerList.add(producer);
        return producer;
    }

    public MockQueueSender createQueueSender() {
        MockQueueSender producer = new MockQueueSender(this.connection, this.session, null);
        this.messageProducerList.add(producer);
        return producer;
    }

    public MockTopicPublisher createTopicPublisher() {
        MockTopicPublisher producer = new MockTopicPublisher(this.connection, this.session, null);
        this.messageProducerList.add(producer);
        return producer;
    }

    public MockMessageProducer getMessageProducer(int index) {
        if (this.messageProducerList.size() <= index || index < 0) {
            return null;
        }
        return (MockMessageProducer)this.messageProducerList.get(index);
    }

    public List getMessageProducerList() {
        return Collections.unmodifiableList(this.messageProducerList);
    }
}

