/*

  Copyright 2004 Protique Ltd

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

 */

package org.activemq.filter.mockrunner;

import javax.jms.JMSException;
import javax.jms.Message;


/**
 * Alwin Ibba: Changed package
 * 
 * Represents a logical not operation on another filter
 *
 * @version $Revision: 1.3 $
 */
public class NotFilter implements Filter {

    private Filter filter;

    public NotFilter(Filter filter) {
        this.filter = filter;
    }

    public boolean matches(Message message) throws JMSException {
        return !filter.matches(message);
    }

    public boolean isWildcard() {
        return false;
    }

}
