/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockMessage;
import com.mockrunner.util.common.ArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Stack;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class MockStreamMessage
extends MockMessage
implements StreamMessage {
    private Stack data = new Stack();
    private boolean remainingBytesPushed = false;

    public boolean readBoolean() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to boolean");
    }

    public byte readByte() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Byte.valueOf(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to byte");
    }

    public short readShort() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to short");
    }

    public char readChar() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to char");
    }

    public int readInt() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Integer.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to int");
    }

    public long readLong() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Long.valueOf(null);
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to long");
    }

    public float readFloat() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Float.valueOf(null).floatValue();
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to float");
    }

    public double readDouble() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return Double.valueOf(null);
        }
        if (value instanceof Float || value instanceof Double) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException(value.getClass().getName() + " cannot be converted to double");
    }

    public String readString() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        Object value = this.readObject();
        if (null == value) {
            return null;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException(value.getClass().getName() + " cannot be converted to String");
        }
        return value.toString();
    }

    public int readBytes(byte[] byteData) throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        if (null == byteData) {
            throw new NullPointerException();
        }
        Object value = this.readObject();
        if (null == value) {
            this.remainingBytesPushed = false;
            return -1;
        }
        if (!(value instanceof byte[])) {
            this.remainingBytesPushed = false;
            throw new MessageFormatException(value.getClass().getName() + " cannot be converted to byte[]");
        }
        int fieldLength = ((byte[])value).length;
        if (0 == fieldLength) {
            if (this.remainingBytesPushed) {
                this.remainingBytesPushed = false;
                return -1;
            }
            return 0;
        }
        if (0 == byteData.length && this.remainingBytesPushed) {
            this.remainingBytesPushed = false;
            return -1;
        }
        this.remainingBytesPushed = false;
        if (fieldLength < byteData.length) {
            System.arraycopy(value, 0, byteData, 0, fieldLength);
            return fieldLength;
        }
        System.arraycopy(value, 0, byteData, 0, byteData.length);
        byte[] remaining = new byte[fieldLength - byteData.length];
        System.arraycopy(value, byteData.length, remaining, 0, remaining.length);
        this.data.push(remaining);
        this.remainingBytesPushed = true;
        return byteData.length;
    }

    public Object readObject() throws JMSException {
        if (this.isInWriteMode()) {
            throw new MessageNotReadableException("Message is in write mode");
        }
        if (this.data.empty()) {
            throw new MessageEOFException("No more data");
        }
        return this.data.pop();
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Boolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Byte(value));
    }

    public void writeShort(short value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Short(value));
    }

    public void writeChar(char value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Character(value));
    }

    public void writeInt(int value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Integer(value));
    }

    public void writeLong(long value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Long(value));
    }

    public void writeFloat(float value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Float(value));
    }

    public void writeDouble(double value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(new Double(value));
    }

    public void writeString(String value) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(value);
    }

    public void writeBytes(byte[] data) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.writeObject(data);
    }

    public void writeBytes(byte[] data, int offset, int length) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == data) {
            this.writeObject(null);
            return;
        }
        this.writeObject(ArrayUtil.truncateArray((Object)data, (int)offset, (int)length));
    }

    public void writeObject(Object object) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        if (null == object) {
            this.data.push(object);
            return;
        }
        if (object instanceof String || object instanceof Number || object instanceof Character || object instanceof Boolean) {
            this.data.push(object);
            return;
        }
        if (object instanceof byte[]) {
            byte[] arrayData = (byte[])((byte[])object).clone();
            this.data.push(arrayData);
            return;
        }
        throw new MessageFormatException(object.getClass() + " not a valid type");
    }

    public void reset() throws JMSException {
        this.setReadOnly(true);
        Collections.reverse(this.data);
        this.remainingBytesPushed = false;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.data = new Stack();
        this.remainingBytesPushed = false;
    }

    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (!(otherObject instanceof MockStreamMessage)) {
            return false;
        }
        MockStreamMessage otherMessage = (MockStreamMessage)otherObject;
        if (this.data.size() != otherMessage.data.size()) {
            return false;
        }
        Vector otherData = otherMessage.data;
        if (this.isInWriteMode() != otherMessage.isInWriteMode()) {
            otherData = new Vector(otherData);
            Collections.reverse(otherData);
        }
        for (int ii = 0; ii < this.data.size(); ++ii) {
            Object nextValue = this.data.get(ii);
            Object otherValue = otherData.get(ii);
            if (null == nextValue) {
                if (null == otherValue) continue;
                return false;
            }
            if (nextValue instanceof byte[]) {
                if (null == otherValue) {
                    return false;
                }
                if (!(otherValue instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])nextValue, (byte[])otherValue)) continue;
                return false;
            }
            if (nextValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int value = 17;
        Vector theData = new Vector(this.data);
        if (this.isInWriteMode()) {
            Collections.reverse(theData);
        }
        for (int ii = 0; ii < theData.size(); ++ii) {
            Object nextValue = theData.get(ii);
            if (nextValue instanceof byte[]) {
                for (int yy = 0; yy < ((byte[])nextValue).length; ++yy) {
                    value = 31 * value + ((byte[])nextValue)[yy];
                }
                continue;
            }
            if (nextValue == null) continue;
            value = 31 * value + nextValue.hashCode();
        }
        return value;
    }

    public Object clone() {
        MockStreamMessage message = (MockStreamMessage)super.clone();
        message.data = new Stack();
        for (int ii = 0; ii < this.data.size(); ++ii) {
            Object nextValue = this.data.get(ii);
            if (nextValue instanceof byte[]) {
                message.data.add(((byte[])nextValue).clone());
                continue;
            }
            message.data.add(nextValue);
        }
        return message;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.data.toString();
    }
}

