/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.mock.jms.MockDestination;
import com.mockrunner.mock.jms.MockQueueReceiver;
import com.mockrunner.mock.jms.MockSession;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;

public class MockQueue
extends MockDestination
implements Queue {
    private String name;

    public MockQueue(String name) {
        this.name = name;
    }

    public String getQueueName() throws JMSException {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message) throws JMSException {
        this.addReceivedMessage(message);
        boolean isConsumed = false;
        Iterator sessionsIterator = this.sessionSet().iterator();
        while (sessionsIterator.hasNext() && !isConsumed) {
            MockSession session = (MockSession)sessionsIterator.next();
            MessageListener globalListener = session.getMessageListener();
            if (null != globalListener) {
                globalListener.onMessage(message);
                isConsumed = true;
                this.acknowledgeMessage(message, session);
                continue;
            }
            List receivers = session.getQueueTransmissionManager().getQueueReceiverList(this.name);
            for (int ii = 0; ii < receivers.size() && !isConsumed; ++ii) {
                MockQueueReceiver receiver = (MockQueueReceiver)receivers.get(ii);
                if (!receiver.canConsume(message)) continue;
                receiver.receiveMessage(message);
                isConsumed = true;
                this.acknowledgeMessage(message, session);
            }
        }
        if (!isConsumed) {
            this.addCurrentMessage(message);
            MockQueue mockQueue = this;
            synchronized (mockQueue) {
                this.notify();
            }
        }
    }
}

