/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.ejb;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.base.VerifyFailedException;
import com.mockrunner.mock.ejb.EJBMockObjectFactory;
import com.mockrunner.mock.ejb.MockUserTransaction;
import com.mockrunner.util.common.ClassUtil;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.beanutils.MethodUtils;
import org.mockejb.BasicEjbDescriptor;
import org.mockejb.EntityBeanDescriptor;
import org.mockejb.MDBDescriptor;
import org.mockejb.SessionBeanDescriptor;
import org.mockejb.TransactionManager;
import org.mockejb.TransactionPolicy;
import org.mockejb.interceptor.AspectSystemFactory;
import org.mockejb.interceptor.ClassPointcut;
import org.mockejb.interceptor.Interceptor;
import org.mockejb.interceptor.Pointcut;

public class EJBTestModule {
    private EJBMockObjectFactory mockFactory;
    private String impSuffix;
    private String homeInterfaceSuffix;
    private String businessInterfaceSuffix;
    private String homeInterfacePackage;
    private String businessInterfacePackage;

    public EJBTestModule(EJBMockObjectFactory mockFactory) {
        this.mockFactory = mockFactory;
        this.impSuffix = "Bean";
        this.homeInterfaceSuffix = "Home";
        this.businessInterfaceSuffix = "";
    }

    public void setImplementationSuffix(String impSuffix) {
        this.impSuffix = impSuffix;
    }

    public void setBusinessInterfaceSuffix(String businessInterfaceSuffix) {
        this.businessInterfaceSuffix = businessInterfaceSuffix;
    }

    public void setHomeInterfaceSuffix(String homeInterfaceSuffix) {
        this.homeInterfaceSuffix = homeInterfaceSuffix;
    }

    public void setInterfacePackage(String interfacePackage) {
        this.setHomeInterfacePackage(interfacePackage);
        this.setBusinessInterfacePackage(interfacePackage);
    }

    public void setHomeInterfacePackage(String homeInterfacePackage) {
        this.homeInterfacePackage = homeInterfacePackage;
    }

    public void setBusinessInterfacePackage(String businessInterfacePackage) {
        this.businessInterfacePackage = businessInterfacePackage;
    }

    public void deploy(BasicEjbDescriptor descriptor) {
        this.deploy(descriptor, TransactionPolicy.SUPPORTS);
    }

    public void deploy(BasicEjbDescriptor descriptor, TransactionPolicy policy) {
        try {
            if (descriptor instanceof SessionBeanDescriptor) {
                this.mockFactory.getMockContainer().deploy((SessionBeanDescriptor)descriptor);
            } else if (descriptor instanceof EntityBeanDescriptor) {
                this.mockFactory.getMockContainer().deploy((EntityBeanDescriptor)descriptor);
            } else if (descriptor instanceof MDBDescriptor) {
                this.mockFactory.getMockContainer().deploy((MDBDescriptor)descriptor);
            }
            if (null != policy) {
                AspectSystemFactory.getAspectSystem().add((Pointcut)new ClassPointcut(descriptor.getIfaceClass(), false), (Interceptor)new TransactionManager(policy));
            }
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void deploySessionBean(String jndiName, Class beanClass) {
        this.deploySessionBean(jndiName, beanClass, false, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String jndiName, Class beanClass, boolean stateful) {
        this.deploySessionBean(jndiName, beanClass, stateful, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String jndiName, Class beanClass, TransactionPolicy policy) {
        this.deploySessionBean(jndiName, beanClass, false, policy);
    }

    public void deploySessionBean(String jndiName, Class beanClass, boolean stateful, TransactionPolicy policy) {
        SessionBeanDescriptor descriptor = new SessionBeanDescriptor(jndiName, this.getHomeClass(beanClass), this.getRemoteClass(beanClass), beanClass);
        descriptor.setStateful(stateful);
        this.deploy((BasicEjbDescriptor)descriptor, policy);
    }

    public void deploySessionBean(String jndiName, Object bean) {
        this.deploySessionBean(jndiName, bean, false, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String jndiName, Object bean, boolean stateful) {
        this.deploySessionBean(jndiName, bean, stateful, TransactionPolicy.SUPPORTS);
    }

    public void deploySessionBean(String jndiName, Object bean, TransactionPolicy policy) {
        this.deploySessionBean(jndiName, bean, false, policy);
    }

    public void deploySessionBean(String jndiName, Object bean, boolean stateful, TransactionPolicy policy) {
        SessionBeanDescriptor descriptor = new SessionBeanDescriptor(jndiName, this.getHomeClass(bean.getClass()), this.getRemoteClass(bean.getClass()), bean);
        descriptor.setStateful(stateful);
        this.deploy((BasicEjbDescriptor)descriptor, policy);
    }

    public void deployEntityBean(String jndiName, Class beanClass) {
        this.deployEntityBean(jndiName, beanClass, TransactionPolicy.SUPPORTS);
    }

    public void deployEntityBean(String jndiName, Class beanClass, TransactionPolicy policy) {
        EntityBeanDescriptor descriptor = new EntityBeanDescriptor(jndiName, this.getHomeClass(beanClass), this.getRemoteClass(beanClass), beanClass);
        this.deploy((BasicEjbDescriptor)descriptor, policy);
    }

    public void deployMessageBean(String connectionFactoryJndiName, String destinationJndiName, ConnectionFactory connectionFactory, Destination destination, Object bean) {
        this.deployMessageBean(connectionFactoryJndiName, destinationJndiName, connectionFactory, destination, bean, TransactionPolicy.NOT_SUPPORTED);
    }

    public void deployMessageBean(String connectionFactoryJndiName, String destinationJndiName, ConnectionFactory connectionFactory, Destination destination, Object bean, TransactionPolicy policy) {
        this.bindToContext(connectionFactoryJndiName, connectionFactory);
        this.bindToContext(destinationJndiName, destination);
        MDBDescriptor descriptor = new MDBDescriptor(connectionFactoryJndiName, destinationJndiName, bean);
        descriptor.setIsAlreadyBound(true);
        descriptor.setIsTopic(destination instanceof Topic);
        this.deploy((BasicEjbDescriptor)descriptor, policy);
    }

    public void bindToContext(String name, Object object) {
        try {
            Context context = this.mockFactory.getContext();
            context.rebind(name, object);
        }
        catch (NamingException exc) {
            throw new RuntimeException("Object with name " + name + " not found.");
        }
    }

    public Object lookup(String name) {
        try {
            Context context = this.mockFactory.getContext();
            return context.lookup(name);
        }
        catch (NamingException exc) {
            throw new RuntimeException("Object with name " + name + " not found.");
        }
    }

    public Object lookupBean(String name) {
        return this.createBean(name);
    }

    public Object createBean(String name) {
        return this.createBean(name, new Object[0]);
    }

    public Object lookupBean(String name, Object[] parameters) {
        return this.createBean(name, parameters);
    }

    public Object createBean(String name, Object[] parameters) {
        return this.createBean(name, "create", parameters);
    }

    public Object lookupBean(String name, String createMethod, Object[] parameters) {
        return this.createBean(name, createMethod, parameters);
    }

    public Object createBean(String name, String createMethod, Object[] parameters) {
        Object home = this.lookupHome(name);
        return this.invokeHomeMethod(home, createMethod, parameters, null);
    }

    public Object createBean(String name, String createMethod, Object[] parameters, Class[] parameterTypes) {
        Object home = this.lookupHome(name);
        return this.invokeHomeMethod(home, createMethod, parameters, parameterTypes);
    }

    public Object createEntityBean(String name, Object primaryKey) {
        return this.createEntityBean(name, new Object[0], primaryKey);
    }

    public Object createEntityBean(String name, Object[] parameters, Object primaryKey) {
        return this.createEntityBean(name, "create", parameters, primaryKey);
    }

    public Object createEntityBean(String name, String createMethod, Object[] parameters, Object primaryKey) {
        return this.createEntityBean(name, createMethod, parameters, null, primaryKey);
    }

    public Object createEntityBean(String name, String createMethod, Object[] parameters, Class[] parameterTypes, Object primaryKey) {
        Object home = this.lookupHome(name);
        Object remote = this.invokeHomeMethod(home, createMethod, parameters, parameterTypes);
        Class[] interfaces = home.getClass().getInterfaces();
        Class homeInterface = this.getHomeInterfaceClass(interfaces);
        if (null != homeInterface && null != remote) {
            this.mockFactory.getMockContainer().getEntityDatabase().add(homeInterface, primaryKey, remote);
        }
        return remote;
    }

    public Object findByPrimaryKey(String name, Object primaryKey) {
        Object home = this.lookupHome(name);
        return this.invokeHomeMethod(home, "findByPrimaryKey", new Object[]{primaryKey}, null);
    }

    private Class getHomeInterfaceClass(Class[] interfaces) {
        for (Class current : interfaces) {
            if (!EJBHome.class.isAssignableFrom(current) && !EJBLocalHome.class.isAssignableFrom(current)) continue;
            return current;
        }
        return null;
    }

    private Object lookupHome(String name) {
        Object object = this.lookup(name);
        if (null == object) {
            return null;
        }
        if (!(object instanceof EJBHome) && !(object instanceof EJBLocalHome)) {
            return null;
        }
        return object;
    }

    private Object invokeHomeMethod(Object home, String methodName, Object[] parameters, Class[] parameterTypes) {
        if (null == parameterTypes) {
            this.checkNullParameters(methodName, parameters);
        }
        try {
            if (null == parameterTypes) {
                return MethodUtils.invokeMethod((Object)home, (String)methodName, (Object[])parameters);
            }
            return MethodUtils.invokeExactMethod((Object)home, (String)methodName, (Object[])parameters, (Class[])parameterTypes);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private void checkNullParameters(String createMethod, Object[] parameters) {
        for (Object parameter : parameters) {
            if (null != parameter) continue;
            String message = "Calling method " + createMethod + " failed. ";
            message = message + "Null is not allowed if the parameter types are not specified.";
            throw new IllegalArgumentException(message);
        }
    }

    public void resetUserTransaction() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            return;
        }
        transaction.reset();
    }

    public void verifyCommitted() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!transaction.wasCommitCalled()) {
            throw new VerifyFailedException("Transaction was not committed.");
        }
    }

    public void verifyNotCommitted() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (transaction.wasCommitCalled()) {
            throw new VerifyFailedException("Transaction was committed.");
        }
    }

    public void verifyRolledBack() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!transaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Transaction was not rolled back");
        }
    }

    public void verifyNotRolledBack() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (transaction.wasRollbackCalled()) {
            throw new VerifyFailedException("Transaction was rolled back");
        }
    }

    public void verifyMarkedForRollback() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (!transaction.wasRollbackOnlyCalled()) {
            throw new VerifyFailedException("Transaction was not marked for rollback");
        }
    }

    public void verifyNotMarkedForRollback() {
        MockUserTransaction transaction = this.mockFactory.getMockUserTransaction();
        if (null == transaction) {
            throw new VerifyFailedException("MockTransaction is null.");
        }
        if (transaction.wasRollbackOnlyCalled()) {
            throw new VerifyFailedException("Transaction was marked for rollback");
        }
    }

    private Class getHomeClass(Class beanClass) {
        String classPackage = ClassUtil.getPackageName((Class)beanClass);
        String className = ClassUtil.getClassName((Class)beanClass);
        className = this.truncateImplClassName(className);
        if (null != this.homeInterfaceSuffix && 0 != this.homeInterfaceSuffix.length()) {
            className = className + this.homeInterfaceSuffix;
        }
        if (null != this.homeInterfacePackage && 0 != this.homeInterfacePackage.length()) {
            classPackage = this.homeInterfacePackage;
        }
        try {
            return Class.forName(this.getClassName(classPackage, className), true, beanClass.getClassLoader());
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException("Home interface not found: " + exc.getMessage());
        }
    }

    private Class getRemoteClass(Class beanClass) {
        String classPackage = ClassUtil.getPackageName((Class)beanClass);
        String className = ClassUtil.getClassName((Class)beanClass);
        className = this.truncateImplClassName(className);
        if (null != this.businessInterfaceSuffix && 0 != this.businessInterfaceSuffix.length()) {
            className = className + this.businessInterfaceSuffix;
        }
        if (null != this.businessInterfacePackage && 0 != this.businessInterfacePackage.length()) {
            classPackage = this.businessInterfacePackage;
        }
        try {
            return Class.forName(this.getClassName(classPackage, className), true, beanClass.getClassLoader());
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException("Interface not found: " + exc.getMessage());
        }
    }

    private String getClassName(String packageName, String className) {
        if (null == packageName || packageName.length() == 0) {
            return className;
        }
        return packageName + "." + className;
    }

    private String truncateImplClassName(String className) {
        if (null != this.impSuffix && className.endsWith(this.impSuffix)) {
            className = className.substring(0, className.length() - this.impSuffix.length());
        }
        return className;
    }
}

