/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.regexp;

import com.mockrunner.util.regexp.PatternMatcher;

public class SimplePatternMatcher
extends PatternMatcher.Base {
    private final String pattern;
    private final boolean caseSensitive;
    private final boolean exactMatch;

    public SimplePatternMatcher(String pattern, boolean caseSensitive, boolean exactMatch) {
        super(pattern);
        this.pattern = exactMatch || caseSensitive ? pattern : pattern.toUpperCase();
        this.caseSensitive = caseSensitive;
        this.exactMatch = exactMatch;
    }

    @Override
    public String type() {
        return "equals";
    }

    @Override
    public boolean matches(String string) {
        if (this.exactMatch) {
            if (this.caseSensitive) {
                return this.pattern.equals(string);
            }
            return this.pattern.equalsIgnoreCase(string);
        }
        if (!this.caseSensitive) {
            string = string.toUpperCase();
        }
        return string.contains(this.pattern);
    }

    public static class Factory
    implements PatternMatcher.Factory {
        private final boolean caseSensitive;
        private final boolean exactMatch;

        public Factory(boolean caseSensitive, boolean exactMatch) {
            this.caseSensitive = caseSensitive;
            this.exactMatch = exactMatch;
        }

        @Override
        public PatternMatcher create(String pattern) {
            return new SimplePatternMatcher(pattern, this.caseSensitive, this.exactMatch);
        }
    }
}

