/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.annotation.CreditCard;
import commons.validator.routines.CreditCardValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CreditCardRule
extends AnnotationRule<CreditCard, String> {
    private static final Map<CreditCard.Type, Long> CARD_TYPE_REGISTRY = new HashMap<CreditCard.Type, Long>(){
        {
            this.put(CreditCard.Type.AMEX, 1L);
            this.put(CreditCard.Type.DINERS, 16L);
            this.put(CreditCard.Type.DISCOVER, 8L);
            this.put(CreditCard.Type.MASTERCARD, 4L);
            this.put(CreditCard.Type.VISA, 2L);
        }
    };

    protected CreditCardRule(CreditCard creditCard) {
        super(creditCard);
    }

    @Override
    public boolean isValid(String creditCardNumber) {
        CreditCard.Type[] types = ((CreditCard)this.mRuleAnnotation).cardTypes();
        HashSet<CreditCard.Type> typesSet = new HashSet<CreditCard.Type>(Arrays.asList(types));
        long options = 0L;
        if (!typesSet.contains((Object)CreditCard.Type.NONE)) {
            for (CreditCard.Type type : typesSet) {
                options += CARD_TYPE_REGISTRY.get((Object)type).longValue();
            }
        } else {
            options = 0L;
        }
        return new CreditCardValidator(options).isValid(creditCardNumber.replaceAll("\\s", ""));
    }
}

