/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.text.TextUtils;
import android.view.View;
import android.widget.Checkable;
import android.widget.Spinner;
import android.widget.TextView;
import com.mobsandgeeks.saripaar.Rule;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public final class Rules {
    public static final String EMPTY_STRING = "";
    public static final String REGEX_INTEGER = "\\d+";
    public static final String REGEX_DECIMAL = "[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?";
    public static final String REGEX_EMAIL = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    public static final String REGEX_IP_ADDRESS = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public static Rule<TextView> required(String failureMessage, final boolean trimInput) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                return !TextUtils.isEmpty((CharSequence)Rules.getText(textView, trimInput));
            }
        };
    }

    public static Rule<TextView> regex(String failureMessage, final String regex, final boolean trimInput) {
        if (regex == null) {
            throw new IllegalArgumentException("'regex' cannot be null");
        }
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                String text = Rules.getText(textView, trimInput);
                return text != null ? text.matches(regex) : false;
            }
        };
    }

    public static Rule<TextView> minLength(String failureMessage, final int minLength, final boolean trimInput) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                String text = Rules.getText(view, trimInput);
                return text != null ? text.length() >= minLength : false;
            }
        };
    }

    public static Rule<TextView> maxLength(String failureMessage, final int maxLength, final boolean trimInput) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                String text = Rules.getText(view, trimInput);
                return text != null ? text.length() <= maxLength : false;
            }
        };
    }

    public static Rule<TextView> eq(String failureMessage, final TextView anotherTextView) {
        if (anotherTextView == null) {
            throw new IllegalArgumentException("'anotherTextView' cannot be null");
        }
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                return ((Object)view.getText()).toString().equals(((Object)anotherTextView.getText()).toString());
            }
        };
    }

    public static Rule<TextView> eq(String failureMessage, String expectedString) {
        return Rules.eq(failureMessage, expectedString, false, false);
    }

    public static Rule<TextView> eq(String failureMessage, String expectedString, final boolean ignoreCase, final boolean trimInput) {
        final String cleanString = expectedString == null ? EMPTY_STRING : expectedString;
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                boolean valid = false;
                String actualString = Rules.getText(textView, trimInput);
                if (actualString != null) {
                    valid = ignoreCase ? actualString.equalsIgnoreCase(cleanString) : actualString.equals(cleanString);
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> eq(String failureMessage, int expectedInt) {
        return Rules.eq(failureMessage, (long)expectedInt);
    }

    public static Rule<TextView> gt(String failureMessage, int lesserInt) {
        return Rules.gt(failureMessage, (long)lesserInt);
    }

    public static Rule<TextView> lt(String failureMessage, int greaterInt) {
        return Rules.lt(failureMessage, (long)greaterInt);
    }

    public static Rule<TextView> eq(String failureMessage, final long expectedLong) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                boolean valid = false;
                String actualLong = Rules.getText(textView, true);
                if (actualLong != null) {
                    valid = actualLong.matches(Rules.REGEX_INTEGER) ? Long.parseLong(actualLong) == expectedLong : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> gt(String failureMessage, final long lesserLong) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                boolean valid = false;
                String actualLong = Rules.getText(textView, true);
                if (actualLong != null) {
                    valid = actualLong.matches(Rules.REGEX_INTEGER) ? Long.parseLong(actualLong) > lesserLong : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> lt(String failureMessage, final long greaterLong) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView textView) {
                boolean valid = false;
                String actualLong = Rules.getText(textView, true);
                if (actualLong != null) {
                    valid = actualLong.matches(Rules.REGEX_INTEGER) ? Long.parseLong(actualLong) < greaterLong : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> eq(String failureMessage, final float expectedFloat) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualFloat = Rules.getText(view, true);
                if (actualFloat != null) {
                    valid = actualFloat.matches(Rules.REGEX_DECIMAL) ? Float.parseFloat(actualFloat) == expectedFloat : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> gt(String failureMessage, final float lesserFloat) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualFloat = Rules.getText(view, true);
                if (actualFloat != null) {
                    valid = actualFloat.matches(Rules.REGEX_DECIMAL) ? Float.parseFloat(actualFloat) > lesserFloat : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> lt(String failureMessage, final float greaterFloat) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualFloat = Rules.getText(view, true);
                if (actualFloat != null) {
                    valid = actualFloat.matches(Rules.REGEX_DECIMAL) ? Float.parseFloat(actualFloat) < greaterFloat : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> eq(String failureMessage, final double expectedDouble) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualDouble = Rules.getText(view, true);
                if (actualDouble != null) {
                    valid = actualDouble.matches(Rules.REGEX_DECIMAL) ? Double.parseDouble(actualDouble) == expectedDouble : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> gt(String failureMessage, final double lesserDouble) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualDouble = Rules.getText(view, true);
                if (actualDouble != null) {
                    valid = actualDouble.matches(Rules.REGEX_DECIMAL) ? Double.parseDouble(actualDouble) > lesserDouble : false;
                }
                return valid;
            }
        };
    }

    public static Rule<TextView> lt(String failureMessage, final double greaterDouble) {
        return new Rule<TextView>(failureMessage){

            @Override
            public boolean isValid(TextView view) {
                boolean valid = false;
                String actualDouble = Rules.getText(view, true);
                if (actualDouble != null) {
                    valid = actualDouble.matches(Rules.REGEX_DECIMAL) ? Double.parseDouble(actualDouble) < greaterDouble : false;
                }
                return valid;
            }
        };
    }

    public static Rule<Checkable> checked(String failureMessage, final boolean checked) {
        return new Rule<Checkable>(failureMessage){

            @Override
            public boolean isValid(Checkable checkableView) {
                return checkableView.isChecked() == checked;
            }
        };
    }

    public static Rule<Spinner> spinnerEq(String failureMessage, final String expectedString, final boolean ignoreCase, final boolean trimInput) {
        return new Rule<Spinner>(failureMessage){

            @Override
            public boolean isValid(Spinner spinner) {
                boolean equals = false;
                Object selectedItem = spinner.getSelectedItem();
                if (expectedString == null && selectedItem == null) {
                    equals = true;
                } else if (expectedString != null && selectedItem != null) {
                    String selectedItemString = selectedItem.toString();
                    selectedItemString = trimInput ? selectedItemString.trim() : selectedItemString;
                    equals = ignoreCase ? selectedItemString.equalsIgnoreCase(expectedString) : selectedItemString.equals(expectedString);
                }
                return equals;
            }
        };
    }

    public static Rule<Spinner> spinnerEq(String failureMessage, final int expectedPosition) {
        return new Rule<Spinner>(failureMessage){

            @Override
            public boolean isValid(Spinner spinner) {
                return spinner.getSelectedItemPosition() == expectedPosition;
            }
        };
    }

    public static Rule<View> and(String failureMessage, final Rule<?> ... rules) {
        return new Rule<View>(failureMessage){

            @Override
            public boolean isValid(View view) {
                boolean valid = true;
                for (Rule rule : rules) {
                    if (rule != null) {
                        valid &= rule.isValid(view);
                    }
                    if (!valid) break;
                }
                return valid;
            }
        };
    }

    public static Rule<View> or(String failureMessage, final Rule<?> ... rules) {
        return new Rule<View>(failureMessage){

            @Override
            public boolean isValid(View view) {
                boolean valid = false;
                for (Rule rule : rules) {
                    if (rule != null) {
                        valid |= rule.isValid(view);
                    }
                    if (valid) break;
                }
                return valid;
            }
        };
    }

    public static Rule<View> compositeAnd(String failureMessage, final LinkedHashMap<View, Rule<?>> viewsAndRules) {
        return new Rule<View>(failureMessage){

            @Override
            public boolean isValid(View view) {
                View viewKey;
                Rule rule;
                boolean valid = true;
                Set keySet = viewsAndRules.keySet();
                Iterator i$ = keySet.iterator();
                while (i$.hasNext() && (valid &= (rule = (Rule)viewsAndRules.get(viewKey = (View)i$.next())).isValid(view))) {
                }
                return valid;
            }
        };
    }

    public static Rule<View> compositeOr(String failureMessage, final LinkedHashMap<View, Rule<?>> viewsAndRules) {
        return new Rule<View>(failureMessage){

            @Override
            public boolean isValid(View view) {
                View viewKey;
                Rule rule;
                boolean valid = false;
                Set keySet = viewsAndRules.keySet();
                Iterator i$ = keySet.iterator();
                while (i$.hasNext() && !(valid |= (rule = (Rule)viewsAndRules.get(viewKey = (View)i$.next())).isValid(viewKey))) {
                }
                return valid;
            }
        };
    }

    private static String getText(TextView textView, boolean trim) {
        CharSequence text = null;
        if (textView != null) {
            text = textView.getText();
            text = trim ? ((Object)text).toString().trim() : text;
        }
        return text != null ? ((Object)text).toString() : null;
    }
}

