/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.CmdRunner;
import com.mks.api.IntegrationPoint;
import com.mks.api.VersionNumber;
import com.mks.api.fedsso.SSOCmdRunner;
import com.mks.api.fedsso.SSOSession;
import com.mks.api.response.APIException;
import com.mks.connect.IntegrationPointImpl;
import com.mks.connect.SSOCmdRunnerImpl;
import com.mks.connect.UserApplicationSessionImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.HttpClient;

final class UserApplicationSSOSessionImpl
implements SSOSession {
    private ConcurrentHashMap<SSOCmdRunner, SSOCmdRunner> cmdRunners = new ConcurrentHashMap();
    final UserApplicationSessionImpl delegate;

    UserApplicationSSOSessionImpl(IntegrationPoint ip, HttpClient httpClient, VersionNumber apiRequestVersion) {
        this.delegate = new UserApplicationSessionImpl(ip, httpClient, null, apiRequestVersion, null, null, false);
        this.delegate.setSSO(true);
        this.delegate.setAutoReconnect(false);
    }

    @Override
    public SSOCmdRunner createCmdRunner(String token) throws APIException {
        CmdRunner cmdRunnerdelegate = this.delegate.createCmdRunner();
        SSOCmdRunnerImpl cmdRunner = new SSOCmdRunnerImpl(this, cmdRunnerdelegate, token);
        this.cmdRunners.put(cmdRunner, cmdRunner);
        return cmdRunner;
    }

    @Override
    public Iterator<SSOCmdRunner> getCmdRunners() {
        return Collections.unmodifiableMap(this.cmdRunners).keySet().iterator();
    }

    @Override
    public IntegrationPoint getIntegrationPoint() {
        return this.delegate.getIntegrationPoint();
    }

    @Override
    public VersionNumber getAPIRequestVersion() {
        return this.delegate.getAPIRequestVersion();
    }

    @Override
    public void release(String token) throws IOException, APIException {
        try {
            this.delegate.release(false, true, token);
            this.cmdRunners.clear();
            ((IntegrationPointImpl)this.getIntegrationPoint()).removeSSOSession(this);
        }
        catch (APIException e) {
            if (!this.delegate.getCmdRunners().hasNext()) {
                this.cmdRunners.clear();
            }
            throw e;
        }
        catch (IOException e) {
            if (!this.delegate.getCmdRunners().hasNext()) {
                this.cmdRunners.clear();
            }
            throw e;
        }
    }

    public void removeSSOCmdRunner(SSOCmdRunner c) {
        this.cmdRunners.remove(c);
    }
}

