/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.response.APIException;
import com.mks.api.response.ICLaunchException;
import com.mks.connect.BlimpException;
import com.mks.connect.HttpCmdRunnerImpl;
import com.mks.connect.IntegrationPointImpl;
import com.mks.connect.UserApplicationSessionImpl;

class ClientCmdRunnerImpl
extends HttpCmdRunnerImpl {
    private static final String BITS_KEY = "sun.arch.data.model";
    private static final String BITS_VALUE_64 = "64";
    private static final String NATIVE_LIBRARY = "apiclientrunner";
    private static final String NATIVE_LIBRARY64 = "apiclientrunner64";
    private static boolean isInitialized = false;

    ClientCmdRunnerImpl(UserApplicationSessionImpl uas) {
        super(uas);
        if (!isInitialized) {
            throw new UnsatisfiedLinkError("Cannot load apiclientrunner");
        }
    }

    private void checkIntegrityClientForLaunch() throws BlimpException, APIException {
        IntegrationPoint ip = this.uas.getIntegrationPoint();
        NativeReturn nr = ClientCmdRunnerImpl.icInitialize(ip.getAutoStartIntegrityClient());
        if (nr == null) {
            throw new BlimpException("Got nothing from icInitialize!!");
        }
        if (nr.port == 0) {
            throw new BlimpException("Integrity Client port not found");
        }
        ((IntegrationPointImpl)ip).setPort(nr.port);
        this.uas.setAuthenticationCookie(nr.cookie);
    }

    @Override
    protected void executePreCondition(String[] cmd) throws APIException {
        try {
            this.checkIntegrityClientForLaunch();
        }
        catch (BlimpException be) {
            throw new APIException(be);
        }
    }

    protected native boolean isIntegrityClientRunning();

    protected static synchronized native NativeReturn icInitialize(boolean var0) throws BlimpException, ICLaunchException;

    static {
        try {
            if (BITS_VALUE_64.equals(System.getProperty(BITS_KEY))) {
                System.loadLibrary(NATIVE_LIBRARY64);
            } else {
                System.loadLibrary(NATIVE_LIBRARY);
            }
            isInitialized = true;
        }
        catch (UnsatisfiedLinkError ule) {
            IntegrationPointFactory.getLogger().exception("API", 0, ule);
        }
    }

    public static class NativeReturn {
        public int port;
        public String cookie;

        public NativeReturn(int port, String cookie) {
            this.port = port;
            this.cookie = cookie;
        }
    }
}

