/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.util;

import java.util.NoSuchElementException;

public class EscapedStringTokenizer {
    private static char BACKSLASH = (char)92;
    private boolean DEBUG = false;
    private int currPos;
    private int maxPos;
    private String str;
    private String delimiters;
    private boolean lastPass;
    private boolean retDelims = false;
    private boolean allowNullToken;
    private boolean start = true;
    public static char[] QUOTES = new char[]{'\'', '\"'};
    private boolean prevBS;
    private boolean currBS;
    private boolean evenBS;
    private char[] bracketingChars = null;
    private char currBktChar;
    private int lastUpdateBSpos;
    private boolean removeBrackets = false;

    public static String escape(String str, String delimiters) {
        if (str == null || str.length() == 0 || delimiters == null || delimiters.length() == 0) {
            return str;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (EscapedStringTokenizer.isDelimiterChar(delimiters, str, i)) {
                buffer.append(BACKSLASH);
            }
            buffer.append(str.charAt(i));
        }
        return buffer.toString();
    }

    public EscapedStringTokenizer(String str, String delim, boolean lastPass) {
        this.str = str;
        this.delimiters = delim != null ? delim : " \t\n\r\f";
        this.lastPass = lastPass;
        this.maxPos = str.length();
        this.rewind();
    }

    public EscapedStringTokenizer(String str, String delim, boolean lastPass, boolean allowNullToken) {
        this(str, delim, lastPass);
        this.allowNullToken = allowNullToken;
    }

    public EscapedStringTokenizer(String str, String delim, boolean lastPass, boolean allowNullToken, boolean retDelims) {
        this(str, delim, lastPass);
        if (retDelims) {
            if (allowNullToken) {
                throw new UnsupportedOperationException("Sorry, this implementation supports either nullTokens  or retDelim but not both.");
            }
            this.allowNullToken = false;
        }
        this.retDelims = retDelims;
    }

    public void defineBracketingChars(char[] bktChars, boolean removeBkts) {
        this.bracketingChars = bktChars;
        this.removeBrackets = removeBkts;
    }

    public void rewind() {
        this.currPos = 0;
        this.resetBS();
    }

    public boolean hasMoreTokens() {
        if ((this.allowNullToken || this.retDelims) && this.currPos < this.maxPos && this.isDelimiter(this.str, this.currPos)) {
            return true;
        }
        this.currPos = this.skipDelimiters(this.str, this.currPos);
        return this.currPos < this.maxPos;
    }

    public String nextToken() {
        if (this.allowNullToken) {
            if (this.start && this.currPos == 0 && this.isDelimiter(this.str, this.currPos)) {
                this.start = false;
                return null;
            }
            if (this.currPos == this.maxPos - 1 && this.isDelimiter(this.str, this.currPos)) {
                ++this.currPos;
                return null;
            }
        }
        this.resetBS();
        this.updateBS(this.str, this.currPos);
        this.currPos = this.skipDelimiters(this.str, this.currPos);
        if (this.allowNullToken && this.currPos < this.maxPos && this.isDelimiter(this.str, this.currPos)) {
            return null;
        }
        if (this.currPos >= this.maxPos) {
            throw new NoSuchElementException();
        }
        int start = this.currPos;
        this.updateBS(this.str, this.currPos);
        while (this.currPos < this.maxPos && !this.isDelimiter(this.str, this.currPos)) {
            ++this.currPos;
            this.updateBS(this.str, this.currPos);
        }
        if (this.retDelims && start == this.currPos && this.isDelimiter(this.str, this.currPos)) {
            ++this.currPos;
            this.updateBS(this.str, this.currPos);
        }
        String token = this.str.substring(start, this.currPos);
        StringBuffer sb = new StringBuffer(token.length());
        if (this.retDelims) {
            sb.append(token);
        } else {
            if (this.DEBUG) {
                System.out.println(" Unescape delimiter chars in token = " + token);
            }
            this.resetBS();
            for (int i = 0; i < token.length(); ++i) {
                this.updateBS(token, i);
                if (this.DEBUG) {
                    System.out.print("    token[" + i + "]=" + token.charAt(i) + ", isDelim=" + this.isDelimiterChar(token, i) + ", isCurrentCharEscaped=" + this.isCurrentCharEscaped());
                }
                if (this.isDelimiterChar(token, i) && this.isCurrentCharEscaped()) {
                    sb.setCharAt(sb.length() - 1, token.charAt(i));
                    if (!this.DEBUG) continue;
                    System.out.println(", sb.setCharAt(" + (sb.length() - 1) + "," + token.charAt(i) + "), sb=" + sb.toString());
                    continue;
                }
                sb.append(token.charAt(i));
                if (!this.DEBUG) continue;
                System.out.println(", sb.append, sb=" + sb.toString());
            }
        }
        if (this.lastPass) {
            boolean prevBS = false;
            boolean currBS = false;
            char currBktChar = '\u0000';
            boolean removeBkts = this.bracketingChars != null && this.removeBrackets;
            int i = 0;
            block2: while (i < sb.length()) {
                if (removeBkts && (!prevBS || this.evenBS)) {
                    if (currBktChar != '\u0000') {
                        if (sb.charAt(i) == currBktChar) {
                            currBktChar = '\u0000';
                            sb.deleteCharAt(i);
                            continue;
                        }
                    } else {
                        char c = sb.charAt(i);
                        for (int j = 0; j < this.bracketingChars.length; ++j) {
                            if (c != this.bracketingChars[j]) continue;
                            currBktChar = c;
                            sb.deleteCharAt(i);
                            continue block2;
                        }
                    }
                }
                boolean bl = currBS = sb.charAt(i) == BACKSLASH;
                if (prevBS && currBS) {
                    sb.deleteCharAt(i);
                    prevBS = false;
                    continue;
                }
                prevBS = currBS;
                ++i;
            }
        }
        return sb.toString();
    }

    private int skipDelimiters(String str, int currPos) {
        while (!this.retDelims && currPos < this.maxPos && this.isDelimiter(str, currPos)) {
            this.updateBS(str, ++currPos);
            if (!this.allowNullToken) continue;
            break;
        }
        return currPos;
    }

    public int countTokens() {
        boolean _prevBS = this.prevBS;
        boolean _currBS = this.currBS;
        boolean _evenBS = this.evenBS;
        char _currBktChar = this.currBktChar;
        int _lastUpdateBSpos = this.lastUpdateBSpos;
        int count = 0;
        int currpos = this.currPos;
        if (this.allowNullToken && this.start && currpos == 0 && this.isDelimiter(this.str, currpos)) {
            ++count;
        }
        while (currpos < this.maxPos) {
            if (this.allowNullToken && currpos == this.maxPos - 1 && this.isDelimiter(this.str, currpos)) {
                ++count;
            }
            if ((currpos = this.skipDelimiters(this.str, currpos)) >= this.maxPos) break;
            int start = currpos;
            this.updateBS(this.str, currpos);
            while (currpos < this.maxPos && !this.isDelimiter(this.str, currpos)) {
                this.updateBS(this.str, ++currpos);
            }
            if (this.retDelims && start == currpos && this.isDelimiter(this.str, currpos)) {
                this.updateBS(this.str, ++currpos);
            }
            ++count;
        }
        this.prevBS = _prevBS;
        this.currBS = _currBS;
        this.evenBS = _evenBS;
        this.currBktChar = _currBktChar;
        this.lastUpdateBSpos = _lastUpdateBSpos;
        return count;
    }

    private void updateBS(String str, int currPos) {
        if (this.lastUpdateBSpos == currPos) {
            return;
        }
        this.lastUpdateBSpos = currPos;
        if (currPos >= str.length()) {
            return;
        }
        if (this.bracketingChars != null && !this.isCurrentCharEscaped()) {
            if (this.currBktChar != '\u0000') {
                if (str.charAt(currPos) == this.currBktChar) {
                    this.currBktChar = '\u0000';
                    return;
                }
            } else {
                char c = str.charAt(currPos);
                for (int i = 0; i < this.bracketingChars.length; ++i) {
                    if (c != this.bracketingChars[i]) continue;
                    this.currBktChar = c;
                    return;
                }
            }
        }
        this.prevBS = this.currBS;
        if (str.charAt(currPos) == BACKSLASH) {
            this.currBS = true;
            this.evenBS = !this.prevBS ? false : !this.evenBS;
        } else {
            this.currBS = false;
        }
    }

    private void resetBS() {
        this.prevBS = false;
        this.currBS = false;
        this.evenBS = true;
        this.lastUpdateBSpos = -1;
        this.currBktChar = '\u0000';
    }

    private boolean isCurrentCharEscaped() {
        return this.prevBS && !this.evenBS;
    }

    private boolean isWithinBrackets() {
        return this.currBktChar != '\u0000';
    }

    private boolean isDelimiter(String str, int currPos) {
        return !this.isWithinBrackets() && !this.isCurrentCharEscaped() && this.isDelimiterChar(str, currPos);
    }

    private boolean isDelimiterChar(String str, int currPos) {
        return EscapedStringTokenizer.isDelimiterChar(this.delimiters, str, currPos);
    }

    private static boolean isDelimiterChar(String delimiters, String str, int currPos) {
        return str.length() != 0 && delimiters.indexOf(str.charAt(currPos)) >= 0;
    }
}

