/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.response.impl;

import com.mks.api.common.XMLResponseDef;
import com.mks.api.response.impl.FieldImpl;
import com.mks.api.response.impl.ItemImpl;
import com.mks.api.response.impl.ItemListImpl;
import com.mks.api.response.impl.ResponseContainer;
import com.mks.api.response.impl.ResponseImpl;
import com.mks.api.response.impl.ResultImpl;
import com.mks.api.response.impl.SubRoutineImpl;
import com.mks.api.response.impl.ValueListImpl;
import com.mks.api.response.impl.WorkItemImpl;
import com.mks.api.response.modifiable.ModifiableField;
import com.mks.api.response.modifiable.ModifiableItem;
import com.mks.api.response.modifiable.ModifiableItemList;
import com.mks.api.response.modifiable.ModifiableResponse;
import com.mks.api.response.modifiable.ModifiableResult;
import com.mks.api.response.modifiable.ModifiableSubRoutine;
import com.mks.api.response.modifiable.ModifiableValueList;
import com.mks.api.response.modifiable.ModifiableWorkItem;
import com.mks.api.response.modifiable.ResponseFactory;
import java.util.Enumeration;
import java.util.Properties;

public final class SimpleResponseFactory
implements ResponseFactory {
    private static SimpleResponseFactory singleton = null;

    public static synchronized SimpleResponseFactory getResponseFactory() {
        if (singleton == null) {
            singleton = new SimpleResponseFactory();
        }
        return singleton;
    }

    private SimpleResponseFactory() {
    }

    @Override
    public ModifiableResponse createResponse() {
        return this.createResponse(null, null);
    }

    public ModifiableResponse createResponse(String appName, String commandName) {
        return new ResponseImpl(new ResponseContainer(), appName, commandName);
    }

    @Override
    public ModifiableWorkItem createWorkItem(String id, String context, String modelType) {
        return this.createWorkItem(id, context, modelType, null);
    }

    public ModifiableWorkItem createWorkItem(String id, String context, String modelType, Properties properties) {
        WorkItemImpl wi = new WorkItemImpl(id, context, modelType);
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                wi.addContext(key, properties.getProperty(key));
            }
        }
        return wi;
    }

    @Override
    public ModifiableSubRoutine createSubRoutine(String name) {
        return new SubRoutineImpl(new ResponseContainer(), name);
    }

    @Override
    public ModifiableItem createItem(String name, String context, String modelType) {
        return this.createItem(name, context, modelType, null);
    }

    public ModifiableItem createItem(String name, String context, String modelType, Properties properties) {
        ItemImpl item = new ItemImpl(name, context, modelType);
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                item.addContext(key, properties.getProperty(key));
            }
        }
        return item;
    }

    @Override
    public ModifiableResult createResult() {
        return new ResultImpl();
    }

    @Override
    public ModifiableItemList createItemList() {
        return new ItemListImpl();
    }

    @Override
    public ModifiableValueList createValueList() {
        return new ValueListImpl();
    }

    @Override
    public ModifiableField createField(String name) {
        return new FieldImpl(name);
    }

    @Override
    public ModifiableField createField(String name, String displayName) {
        return new FieldImpl(name, displayName);
    }

    public static String toFieldDataType(String xmlDataType) {
        if (XMLResponseDef.XML_SELECTION_TAG.equals(xmlDataType)) {
            return "com.mks.api.response.ItemList";
        }
        if (XMLResponseDef.XML_LIST_TAG.equals(xmlDataType)) {
            return "com.mks.api.response.ValueList";
        }
        if (XMLResponseDef.XML_DATATYPE_ITEM.equals(xmlDataType)) {
            return "com.mks.api.response.Item";
        }
        if (XMLResponseDef.XML_DATATYPE_INT.equals(xmlDataType)) {
            return "java.lang.Integer";
        }
        if (XMLResponseDef.XML_DATATYPE_BOOLEAN.equals(xmlDataType)) {
            return "java.lang.Boolean";
        }
        if (XMLResponseDef.XML_DATATYPE_DOUBLE.equals(xmlDataType)) {
            return "java.lang.Double";
        }
        if (XMLResponseDef.XML_DATATYPE_FLOAT.equals(xmlDataType)) {
            return "java.lang.Float";
        }
        if (XMLResponseDef.XML_DATATYPE_LONG.equals(xmlDataType)) {
            return "java.lang.Long";
        }
        if (XMLResponseDef.XML_DATATYPE_TIMESTAMP.equals(xmlDataType)) {
            return "java.util.Date";
        }
        if (XMLResponseDef.XML_DATATYPE_STRING.equals(xmlDataType)) {
            return "java.lang.String";
        }
        if (XMLResponseDef.XML_DATATYPE_BINARY.equals(xmlDataType)) {
            return "[B";
        }
        return null;
    }
}

