/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.response.APIError;
import com.mks.api.response.APIException;
import com.mks.api.response.Field;
import com.mks.api.response.InvalidItemException;
import com.mks.api.response.Item;
import com.mks.api.response.ItemNotFoundException;
import com.mks.api.response.WorkItem;
import com.mks.api.response.impl.SimpleResponseFactory;
import com.mks.api.response.modifiable.ModifiableField;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class WorkingFile
implements Item {
    public static final String INVALID_MOVE_TO_CP_OPERATION = "INVALID_MOVE_TO_CP_OPERATION";
    private long ordinal;
    private boolean valid;
    private static final String WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER = "exclusiveLockedByOther";
    private static final String WF_FIELD_LOCKED_BY_OTHER = "lockedByOther";
    private static final String WF_FIELD_LOCKED_BY_ME = "lockedByMe";
    private static final String WF_FIELD_OUT_OF_DATE = "outOfDate";
    private static final String WF_FIELD_MODIFIED = "modified";
    private static final String WF_FIELD_INCOMING = "incoming";
    private static final String WF_FIELD_MOVED = "moved";
    private static final String WF_FIELD_RENAMED = "renamed";
    private static final String WF_FIELD_DROPPED = "dropped";
    private static final String WF_FIELD_ADDED = "added";
    private static final String WF_FIELD_FORMER_MEMBER = "formerMember";
    private static final String WF_FIELD_MEMBER = "member";
    private static final String WF_FIELD_CONTROLLED = "controlled";
    private static final String WF_FIELD_IN_SANDBOX_DIR = "inSandboxDir";
    private static final String WF_FIELD_WORKING_DELTA = "workingDelta";
    private static final String WF_FIELD_WORKING_CPID = "workingCpid";
    private static final String WF_FIELD_WORKING_REV = "workingRev";
    private static final String WF_FIELD_MEMBER_REV = "memberRev";
    private static final String WF_FIELD_SANDBOX = "sandbox";
    private static final String WF_FIELD_SANDBOX_INFO = "sandboxInfo";
    private static final String WF_FIELD_MEMBER_NAME = "memberName";
    private static final String WF_FIELD_MEMBER_NAME_RELATIVE = "memberNameRelative";
    private static final String WF_FIELD_MEMBER_SANDBOX = "memberSandbox";
    private static final String WF_FIELD_IS_PENDING = "pending";
    private static final String WF_FIELD_IS_PENDING_ADD = "pendingAdd";
    private static final String WF_FIELD_EXCLUSIVE = "exclusiveLockedByMe";
    private static final String WF_FIELD_SUBMITTABLE = "submittable";
    private static final String WF_FIELD_INVALID = "invalid";
    private static final String WF_FIELD_ORDINAL = "ordinal";
    private static final String WF_FIELD_HAS_MERGE_CONFLICT = "hasMergeConflict";
    private static final String[] fields = new String[]{"exclusiveLockedByOther", "lockedByOther", "lockedByMe", "outOfDate", "modified", "incoming", "moved", "renamed", "dropped", "added", "formerMember", "member", "controlled", "inSandboxDir", "workingDelta", "workingCpid", "workingRev", "memberRev", "sandbox", "sandboxInfo", "memberName", "pending", "pendingAdd", "exclusiveLockedByMe", "submittable", "invalid", "ordinal", "memberNameRelative", "memberSandbox", "hasMergeConflict"};
    private File memberNameRelative = null;
    private boolean controlled = false;
    private boolean member = false;
    private boolean formerMember = false;
    private boolean added = false;
    private boolean dropped = false;
    private boolean moved = false;
    private boolean renamed = false;
    private boolean modified = false;
    private boolean outOfDate = false;
    private boolean incoming = false;
    private boolean submittable = false;
    private boolean lockedByMe = false;
    private boolean lockedByOther = false;
    private boolean exclusiveLockedByOther = false;
    private boolean isPending = false;
    private boolean isPendingAdd = false;
    private boolean exclusive = false;
    private boolean workingDelta = false;
    private boolean hasMergeConflict = false;
    private String workingCPID = null;
    private String workingRevision = null;
    private String memberRevision = null;
    private SandboxInfo sandboxInfo = null;
    private File memberSandbox = null;
    private File file;
    private File root;
    private APIException exception = null;

    public WorkingFile(Item wfGetStatusWorkItem) {
        if (wfGetStatusWorkItem.getField(WF_FIELD_MEMBER_NAME_RELATIVE).getValueAsString() != null) {
            this.memberNameRelative = new File(wfGetStatusWorkItem.getField(WF_FIELD_MEMBER_NAME_RELATIVE).getValueAsString());
        }
        if (wfGetStatusWorkItem.getField(WF_FIELD_MEMBER_SANDBOX).getValueAsString() != null) {
            this.memberSandbox = new File(wfGetStatusWorkItem.getField(WF_FIELD_MEMBER_SANDBOX).getValueAsString());
        }
        this.controlled = wfGetStatusWorkItem.getField(WF_FIELD_CONTROLLED).getBoolean();
        this.member = wfGetStatusWorkItem.getField(WF_FIELD_MEMBER).getBoolean();
        this.formerMember = wfGetStatusWorkItem.getField(WF_FIELD_FORMER_MEMBER).getBoolean();
        this.added = wfGetStatusWorkItem.getField(WF_FIELD_ADDED).getBoolean();
        this.dropped = wfGetStatusWorkItem.getField(WF_FIELD_DROPPED).getBoolean();
        this.moved = wfGetStatusWorkItem.getField(WF_FIELD_MOVED).getBoolean();
        this.renamed = wfGetStatusWorkItem.getField(WF_FIELD_RENAMED).getBoolean();
        this.modified = wfGetStatusWorkItem.getField(WF_FIELD_MODIFIED).getBoolean();
        this.outOfDate = wfGetStatusWorkItem.getField(WF_FIELD_OUT_OF_DATE).getBoolean();
        this.incoming = wfGetStatusWorkItem.getField(WF_FIELD_INCOMING).getBoolean();
        this.lockedByMe = wfGetStatusWorkItem.getField(WF_FIELD_LOCKED_BY_ME).getBoolean();
        this.lockedByOther = wfGetStatusWorkItem.getField(WF_FIELD_LOCKED_BY_OTHER).getBoolean();
        this.exclusiveLockedByOther = wfGetStatusWorkItem.getField(WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER).getBoolean();
        this.isPending = wfGetStatusWorkItem.getField(WF_FIELD_IS_PENDING).getBoolean();
        this.isPendingAdd = wfGetStatusWorkItem.getField(WF_FIELD_IS_PENDING_ADD).getBoolean();
        this.exclusive = wfGetStatusWorkItem.getField(WF_FIELD_EXCLUSIVE).getBoolean();
        this.workingDelta = wfGetStatusWorkItem.getField(WF_FIELD_WORKING_DELTA).getBoolean();
        this.workingCPID = wfGetStatusWorkItem.getField(WF_FIELD_WORKING_CPID).getValueAsString();
        this.workingRevision = wfGetStatusWorkItem.getField(WF_FIELD_WORKING_REV).getValueAsString();
        this.memberRevision = wfGetStatusWorkItem.getField(WF_FIELD_MEMBER_REV).getValueAsString();
        this.sandboxInfo = SandboxInfo.createFromWFWI(wfGetStatusWorkItem.getField(WF_FIELD_SANDBOX_INFO).getItem());
        this.submittable = wfGetStatusWorkItem.getField(WF_FIELD_SUBMITTABLE).getBoolean();
        this.hasMergeConflict = wfGetStatusWorkItem.getField(WF_FIELD_HAS_MERGE_CONFLICT).getBoolean();
        this.file = new File(wfGetStatusWorkItem.getId());
        this.valid = wfGetStatusWorkItem.getField(WF_FIELD_INVALID).getBoolean() == false;
        this.ordinal = wfGetStatusWorkItem.getField(WF_FIELD_ORDINAL).getLong();
        if (this.memberRevision != null && this.memberRevision.equals(this.workingRevision)) {
            this.memberRevision = this.workingRevision;
        }
    }

    WorkingFile(File file, SandboxInfo sandbox, WorkingFileFactory.WorkingRoot workingRoot, WorkItem viewsandboxWorkItem, Date timestamp, String userId, long ordinal) {
        this(file, sandbox, workingRoot, false, null, timestamp, ordinal);
        this.generateFromWorkItem(viewsandboxWorkItem, userId);
    }

    WorkingFile(File file, APIException ex, Date timestamp, long ordinal) {
        this(file, null, null, false, ex, timestamp, ordinal);
    }

    WorkingFile(File file, SandboxInfo sandbox, WorkingFileFactory.WorkingRoot workingRoot, Date timestamp, long ordinal) {
        this(file, sandbox, workingRoot, false, null, timestamp, ordinal);
    }

    WorkingFile(SandboxInfo sandbox, WorkingFileFactory.WorkingRoot workingRoot, Date timestamp, long ordinal) {
        this(sandbox.getSandboxFile(), sandbox, workingRoot, true, null, timestamp, ordinal);
    }

    private WorkingFile(File file, SandboxInfo sandbox, WorkingFileFactory.WorkingRoot workingRoot, boolean controlled, APIException ex, Date timestamp, long ordinal) {
        if (timestamp == null) {
            throw new APIError("Assertion: Working File missing timestamp");
        }
        this.file = file;
        this.ordinal = ordinal;
        this.root = workingRoot != null ? workingRoot.getRoot() : null;
        this.sandboxInfo = sandbox;
        this.controlled = controlled;
        if (ex == null) {
            if (file == null || file.isDirectory()) {
                ex = new InvalidItemException();
            }
            if (!file.exists()) {
                ex = new ItemNotFoundException();
            }
        }
        this.setAPIException(ex);
    }

    private void generateFromWorkItem(WorkItem wi, String userId) {
        APIException apix = wi.getAPIException();
        if (apix != null) {
            String exceptionName = apix.getField("exception-name").getString();
            if (apix instanceof ItemNotFoundException) {
                if (!"si.MemberNotFound".equals(exceptionName)) {
                    if ("si.NoSuchSubproject".equals(exceptionName)) {
                        this.formerMember = true;
                    } else {
                        this.setAPIException(apix);
                    }
                }
                return;
            }
            this.setAPIException(apix);
            return;
        }
        if (this.getAPIException() instanceof ItemNotFoundException) {
            this.setAPIException(null);
        }
        this.controlled = true;
        if ("si.Sandbox".equals(wi.getModelType()) || "si.Project".equals(wi.getModelType())) {
            this.memberNameRelative = new File(this.file.getName());
            return;
        }
        try {
            Item item;
            String name = wi.getField("name").getString();
            this.file = new File(name);
            this.memberNameRelative = new File(wi.getField("canonicalMember").getString());
            this.memberSandbox = new File(wi.getField("canonicalSandbox").getString());
            if (this.sandboxInfo.getSandboxFile().equals(this.memberSandbox)) {
                this.memberSandbox = null;
            }
            if (this.file.equals(this.getMemberName())) {
                this.memberNameRelative = null;
            }
            if ("si.FormerMember".equals(wi.getModelType())) {
                this.formerMember = true;
                return;
            }
            try {
                item = wi.getField("workingcpid").getItem();
                if (item != null) {
                    this.workingCPID = item.getId();
                }
            }
            catch (NoSuchElementException nsex) {
                this.workingCPID = null;
            }
            try {
                this.hasMergeConflict = wi.getField(WF_FIELD_HAS_MERGE_CONFLICT).getBoolean();
            }
            catch (NoSuchElementException nsex) {
                this.hasMergeConflict = false;
            }
            if (!this.file.equals(this.getMemberName())) {
                String fileName = this.file.getName();
                String filePath = String.valueOf(this.file.getParent());
                String memberFileName = this.getMemberName().getName();
                String memberPath = String.valueOf(this.getMemberName().getParent());
                if (!fileName.equals(memberFileName)) {
                    this.renamed = true;
                }
                if (!filePath.equals(memberPath)) {
                    this.moved = true;
                }
            }
            this.submittable = wi.getField("deferred").getBoolean();
            String type = wi.getField("type").getString();
            if ("si.DestinedMember".equals(wi.getModelType())) {
                if ("deferred-add".equals(type)) {
                    this.added = true;
                    return;
                }
                if ("deferred-move-to".equals(type)) {
                    return;
                }
            }
            this.member = true;
            if (type.indexOf("pending-add") != -1) {
                this.isPendingAdd = true;
            }
            if ("si.DoomedMember".equals(wi.getModelType())) {
                this.dropped = true;
            }
            if ((item = wi.getField("memberrev").getItem()) != null) {
                this.memberRevision = item.getId();
            }
            if ((item = wi.getField("workingrev").getItem()) != null) {
                this.workingRevision = item.getId();
            }
            if (this.memberRevision != null && this.memberRevision.equals(this.workingRevision)) {
                this.workingRevision = this.memberRevision;
            }
            item = wi.getField("wfdelta").getItem();
            boolean wfDelta = false;
            boolean wfDeltaSizeChanged = false;
            boolean noWorkingFile = false;
            boolean checksumDifferent = false;
            if (item != null) {
                Boolean chksumDiff;
                Long currentSize;
                Boolean noWfObj;
                Boolean wfDeltaObj = item.getField("isDelta").getBoolean();
                if (wfDeltaObj != null) {
                    wfDelta = wfDeltaObj;
                }
                if ((noWfObj = item.getField("noWorkingFile").getBoolean()) != null) {
                    noWorkingFile = noWfObj;
                }
                if ((currentSize = item.getField("workingFileSize").getLong()) != null) {
                    Long cachedSize = item.getField("cachedFileSize").getLong();
                    boolean bl = wfDeltaSizeChanged = !currentSize.equals(cachedSize);
                }
                if ((chksumDiff = item.getField("checksumDifferent").getBoolean()) != null) {
                    checksumDifferent = chksumDiff;
                }
            }
            item = wi.getField("revsyncdelta").getItem();
            boolean revSyncDelta = false;
            boolean isWorkingRevUnknown = false;
            if (item != null) {
                Boolean isWorkingRevPendingObj;
                Boolean isWorkingRevUnknownObj;
                Boolean revSyncDeltaObj = item.getField("isDelta").getBoolean();
                if (revSyncDeltaObj != null) {
                    revSyncDelta = revSyncDeltaObj;
                }
                if ((isWorkingRevUnknownObj = item.getField("isWorkingRevUnknown").getBoolean()) != null) {
                    isWorkingRevUnknown = isWorkingRevUnknownObj;
                }
                if ((isWorkingRevPendingObj = item.getField("isWorkingRevPending").getBoolean()) != null) {
                    this.isPending = isWorkingRevPendingObj;
                }
            }
            if (wfDelta && !noWorkingFile) {
                this.workingDelta = true;
                if (wfDeltaSizeChanged) {
                    this.markModified();
                } else if (this.sandboxInfo.isComputeChecksums() && checksumDifferent) {
                    this.markModified();
                } else if (isWorkingRevUnknown) {
                    this.markModified();
                }
            }
            if (noWorkingFile && isWorkingRevUnknown) {
                this.incoming = true;
            }
            if (revSyncDelta) {
                this.outOfDate = true;
            }
            String devPath = this.sandboxInfo != null ? this.sandboxInfo.getDevPath() : null;
            List lockRecords = wi.getField("lockrecord").getList();
            if (lockRecords != null) {
                for (Item lockRecord : lockRecords) {
                    Item revision = lockRecord.getField("revision").getItem();
                    Item user = lockRecord.getField("locker").getItem();
                    String lockType = lockRecord.getField("locktype").getValueAsString();
                    String lockDevPath = lockRecord.getField("lockdevpath").getValueAsString();
                    if (user == null || revision == null || this.workingRevision == null || !this.workingRevision.equals(revision.getId()) || (devPath != null || lockDevPath != null) && (devPath == null || !devPath.equals(lockDevPath))) continue;
                    if (user.getId().equals(userId)) {
                        this.lockedByMe = true;
                        if (!"exclusive".equals(lockType)) continue;
                        this.exclusive = true;
                        continue;
                    }
                    this.lockedByOther = true;
                    if (!"exclusive".equals(lockType)) continue;
                    this.exclusiveLockedByOther = true;
                }
            }
        }
        catch (NoSuchElementException nsex) {
            this.setAPIException(new APIException(nsex));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkingFile)) {
            return false;
        }
        WorkingFile other = (WorkingFile)obj;
        if (this.added != other.added) {
            return false;
        }
        if (this.controlled != other.controlled) {
            return false;
        }
        if (this.dropped != other.dropped) {
            return false;
        }
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.exclusiveLockedByOther != other.exclusiveLockedByOther) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.formerMember != other.formerMember) {
            return false;
        }
        if (this.incoming != other.incoming) {
            return false;
        }
        if (this.isPending != other.isPending) {
            return false;
        }
        if (this.isPendingAdd != other.isPendingAdd) {
            return false;
        }
        if (this.lockedByMe != other.lockedByMe) {
            return false;
        }
        if (this.lockedByOther != other.lockedByOther) {
            return false;
        }
        if (this.member != other.member) {
            return false;
        }
        if (this.memberNameRelative == null ? other.memberNameRelative != null : !this.memberNameRelative.equals(other.memberNameRelative)) {
            return false;
        }
        if (this.memberRevision == null ? other.memberRevision != null : !this.memberRevision.equals(other.memberRevision)) {
            return false;
        }
        if (this.modified != other.modified) {
            return false;
        }
        if (this.moved != other.moved) {
            return false;
        }
        if (this.ordinal != other.ordinal) {
            return false;
        }
        if (this.outOfDate != other.outOfDate) {
            return false;
        }
        if (this.renamed != other.renamed) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        if (this.sandboxInfo == null ? other.sandboxInfo != null : !this.sandboxInfo.equals(other.sandboxInfo)) {
            return false;
        }
        if (this.submittable != other.submittable) {
            return false;
        }
        if (this.valid != other.valid) {
            return false;
        }
        if (this.workingCPID == null ? other.workingCPID != null : !this.workingCPID.equals(other.workingCPID)) {
            return false;
        }
        if (this.workingDelta != other.workingDelta) {
            return false;
        }
        if (this.workingRevision == null ? other.workingRevision != null : !this.workingRevision.equals(other.workingRevision)) {
            return false;
        }
        return !(this.memberSandbox == null ? other.memberSandbox != null : !this.memberSandbox.equals(other.memberSandbox));
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    public boolean isInSandboxDir() {
        return this.sandboxInfo != null;
    }

    public boolean isControlled() {
        return this.controlled;
    }

    public boolean isMember() {
        return this.member;
    }

    public boolean isSandbox() {
        return this.getMemberName() != null && this.getMemberSandbox() != null && this.getMemberName().equals(this.getMemberSandbox());
    }

    public boolean isFormerMember() {
        return this.formerMember;
    }

    public boolean isChangePackageValid() {
        return this.isCPValid(this.getWorkingCpid());
    }

    public boolean isNullCP() {
        String workingCP = this.getWorkingCpid();
        return this.isCPValid(workingCP) && ":none".equals(workingCP);
    }

    private boolean isCPValid(String workingCP) {
        return workingCP != null && workingCP.length() != 0;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public boolean isRenamed() {
        return this.renamed;
    }

    public boolean isMovedOrRenamed() {
        return this.isMoved() || this.isRenamed();
    }

    public boolean isDeferred() {
        return this.getWorkingCpid() != null || this.isAdded() || this.isDropped() || this.isMoved() || this.isRenamed();
    }

    public boolean hasWorkingDelta() {
        return this.workingDelta;
    }

    void markModified() {
        this.modified = true;
    }

    void markFormer() {
        this.formerMember = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isOutOfDate() {
        return this.outOfDate;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isLockedByMe() {
        return this.lockedByMe;
    }

    public boolean isLockedByOther() {
        return this.lockedByOther;
    }

    public boolean isExclusiveLockByOther() {
        return this.exclusiveLockedByOther;
    }

    public boolean isExclusiveLockByMe() {
        return this.exclusive;
    }

    public boolean isPending() {
        return this.isPending;
    }

    public boolean isPendingAdd() {
        return this.isPendingAdd;
    }

    public boolean hasMergeConflict() {
        return this.hasMergeConflict;
    }

    public File getMemberName() {
        if (this.memberNameRelative != null && this.getMemberSandbox() != null) {
            return new File(this.getMemberSandbox().getParentFile(), this.memberNameRelative.getPath());
        }
        return this.file;
    }

    public File getMemberNameRelative() {
        if (this.memberNameRelative != null) {
            return this.memberNameRelative;
        }
        if (this.getMemberSandbox() != null) {
            return new File(this.file.toString().substring(this.getMemberSandbox().getParent().length() + 1));
        }
        return null;
    }

    public File getMemberSandbox() {
        if (this.memberSandbox == null) {
            return this.getSandboxFile();
        }
        return this.memberSandbox;
    }

    public String getMemberRev() {
        return this.memberRevision;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.getFile().getAbsolutePath();
    }

    public String getSandbox() {
        return this.sandboxInfo != null ? this.sandboxInfo.getSandboxFile().getAbsolutePath() : null;
    }

    public File getSandboxFile() {
        String path = this.getSandbox();
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public final SandboxInfo getSandboxInfo() {
        return this.sandboxInfo;
    }

    public String getWorkingCpid() {
        return this.workingCPID;
    }

    public String getWorkingCpidOrNone() {
        if (this.workingCPID != null) {
            return this.workingCPID;
        }
        return ":none";
    }

    public String getWorkingRev() {
        return this.workingRevision;
    }

    public File getWorkingRoot() {
        return this.root;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String statusString() {
        String string = "Working File: " + this.getName() + "\n" + " Member Name: " + this.getMemberName() + "\n" + " Working Root: " + this.getWorkingRoot() + "\n" + " Working CPID: " + this.getWorkingCpid() + "\n" + " Member Rev: " + this.getMemberRev() + "\n" + " Working Rev: " + this.getWorkingRev() + "\n" + " Invalid: " + this.isInvalid() + "\n" + " In Sandbox Dir: " + this.isInSandboxDir() + "\n" + " isControlled: " + this.isControlled() + "\n" + " member: " + this.isMember() + "\n" + " former Member: " + this.isFormerMember() + "\n" + " added: " + this.isAdded() + "\n" + " dropped: " + this.isDropped() + "\n" + " moved: " + this.isMoved() + "\n" + " renamed: " + this.isRenamed() + "\n" + " has WF Delta: " + this.hasWorkingDelta() + "\n" + " modified: " + this.isModified() + "\n" + " incoming: " + this.isIncoming() + "\n" + " outOfDate: " + this.isOutOfDate() + "\n" + " locked by me: " + this.isLockedByMe() + "\n" + " locked by other: " + this.isLockedByOther() + "\n" + " deferred: " + this.isDeferred() + "\n" + " exclusive by other: " + this.isExclusiveLockByOther() + "\n" + " exclusive by me: " + this.isExclusiveLockByMe() + "\n" + " has merge conflict: " + this.hasMergeConflict() + "\n" + " pending: " + this.isPending() + "\n" + " pending Add: " + this.isPendingAdd() + "\n" + " ordinal: " + this.getOrdinal() + "\n";
        if (this.exception != null) {
            string = string + " exception: " + this.exception.getExceptionId() + "\n";
        }
        return string;
    }

    private void setAPIException(APIException exception) {
        this.exception = exception;
        this.valid = exception == null;
    }

    public APIException getAPIException() {
        return this.exception;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getContext() {
        return this.getSandbox();
    }

    @Override
    public String getContext(String key) {
        return null;
    }

    @Override
    public Enumeration getContextKeys() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    @Override
    public String getDisplayId() {
        return null;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getModelType() {
        return "si.WorkingFile";
    }

    @Override
    public boolean contains(String id) {
        for (String fieldId : fields) {
            if (!fieldId.equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Field getField(String id) {
        Object fieldValue = null;
        if (WF_FIELD_INVALID.equals(id)) {
            fieldValue = this.isInvalid() ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_ORDINAL.equals(id)) {
            fieldValue = new Long(this.ordinal);
        } else if (WF_FIELD_MEMBER_NAME.equals(id)) {
            fieldValue = this.getMemberName();
        } else if (WF_FIELD_SANDBOX.equals(id)) {
            fieldValue = this.getSandbox();
        } else if (WF_FIELD_IN_SANDBOX_DIR.equals(id)) {
            fieldValue = this.isInSandboxDir() ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_CONTROLLED.equals(id)) {
            fieldValue = this.controlled ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_MEMBER.equals(id)) {
            fieldValue = this.member ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_FORMER_MEMBER.equals(id)) {
            fieldValue = this.formerMember ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_ADDED.equals(id)) {
            fieldValue = this.added ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_DROPPED.equals(id)) {
            fieldValue = this.dropped ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_MOVED.equals(id)) {
            fieldValue = this.moved ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_RENAMED.equals(id)) {
            fieldValue = this.renamed ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_MODIFIED.equals(id)) {
            fieldValue = this.modified ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_OUT_OF_DATE.equals(id)) {
            fieldValue = this.outOfDate ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_INCOMING.equals(id)) {
            fieldValue = this.incoming ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_LOCKED_BY_ME.equals(id)) {
            fieldValue = this.lockedByMe ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_EXCLUSIVE.equals(id)) {
            fieldValue = this.exclusive ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_LOCKED_BY_OTHER.equals(id)) {
            fieldValue = this.lockedByOther ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_EXCLUSIVE_LOCKED_BY_OTHER.equals(id)) {
            fieldValue = this.exclusiveLockedByOther ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_IS_PENDING.equals(id)) {
            fieldValue = this.isPending ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_IS_PENDING_ADD.equals(id)) {
            fieldValue = this.isPendingAdd ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_SUBMITTABLE.equals(id)) {
            fieldValue = this.submittable ? Boolean.TRUE : Boolean.FALSE;
        } else if (WF_FIELD_WORKING_CPID.equals(id)) {
            fieldValue = this.workingCPID;
        } else if (WF_FIELD_WORKING_DELTA.equals(id)) {
            fieldValue = this.workingDelta;
        } else if (WF_FIELD_WORKING_REV.equals(id)) {
            fieldValue = this.workingRevision;
        } else if (WF_FIELD_MEMBER_REV.equals(id)) {
            fieldValue = this.memberRevision;
        } else if (WF_FIELD_SANDBOX_INFO.equals(id)) {
            fieldValue = this.sandboxInfo;
        } else if (WF_FIELD_MEMBER_NAME_RELATIVE.equals(id)) {
            fieldValue = this.memberNameRelative;
        } else if (WF_FIELD_MEMBER_SANDBOX.equals(id)) {
            fieldValue = this.memberSandbox;
        } else if (WF_FIELD_HAS_MERGE_CONFLICT.equals(id)) {
            fieldValue = this.hasMergeConflict;
        } else {
            throw new NoSuchElementException(id);
        }
        SimpleResponseFactory factory = SimpleResponseFactory.getResponseFactory();
        ModifiableField field = factory.createField(id);
        field.setValue(fieldValue);
        return field;
    }

    @Override
    public int getFieldListSize() {
        return fields.length;
    }

    @Override
    public Iterator<Field> getFields() {
        ArrayList<Field> itemFields = new ArrayList<Field>(this.getFieldListSize());
        for (String id : fields) {
            itemFields.add(this.getField(id));
        }
        return itemFields.iterator();
    }
}

