/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.GenericWFCommandRunner;
import com.mks.api.commands.SIAddCommand;
import com.mks.api.commands.SIDropCommand;
import com.mks.api.commands.SILockCommand;
import com.mks.api.commands.SIMoveCommand;
import com.mks.api.commands.SIRenameCommand;
import com.mks.api.commands.WFTrackCommandBase;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingDirectoryFactory;
import com.mks.api.commands.ide.WorkingFile;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.commands.ide.WorkingFileList;
import com.mks.api.response.APIException;
import com.mks.api.response.Response;
import java.io.File;

class WFTrackMovedFile
extends WFTrackCommandBase {
    private File newName = null;

    WFTrackMovedFile(CmdRunnerCreator session) throws APIException {
        super(session);
    }

    @Override
    protected Response execute(WorkingFileList workingFiles) throws APIException {
        File file;
        WorkingFile memberWF;
        String targetName;
        if (workingFiles.size() > 1) {
            throw new APIException("WFTrackMovedFile command accepts single selection only.");
        }
        if (this.newName == null) {
            throw new APIException("WFTrackMovedFile requires a new name for the file.");
        }
        WorkingFile sourceWF = workingFiles.getList().get(0);
        WorkingFile targetWF = WorkingFileFactory.getWorkingFile(this.getCmdRunnerCreator(), this.newName, true);
        if (sourceWF.getWorkingRoot() == null && targetWF.getWorkingRoot() == null) {
            return null;
        }
        if (sourceWF.getFile().equals(this.newName)) {
            return null;
        }
        boolean toBeReverted = false;
        boolean toBeAdded = false;
        boolean toBeDropped = false;
        boolean toBeLocked = false;
        boolean toBeMoved = false;
        boolean toBeRenamed = false;
        boolean cleanUpSrc = false;
        if (!(sourceWF.getWorkingRoot() != null && sourceWF.isControlled() || targetWF.getWorkingRoot() == null)) {
            toBeAdded = true;
        } else if (sourceWF.getWorkingRoot() != null && targetWF.getWorkingRoot() == null) {
            if (sourceWF.isMember()) {
                toBeDropped = true;
            } else if (sourceWF.isAdded()) {
                toBeReverted = true;
            }
        } else if (sourceWF.isAdded()) {
            toBeReverted = true;
            toBeAdded = true;
        } else {
            if (!sourceWF.getFile().getName().equals(this.newName.getName())) {
                if (sourceWF.getMemberName().getName().equals(this.newName.getName())) {
                    toBeReverted = true;
                    if (!sourceWF.getMemberName().getParentFile().equals(this.newName.getParentFile())) {
                        toBeMoved = true;
                        cleanUpSrc = true;
                    }
                    if (sourceWF.isLockedByMe() || sourceWF.isModified()) {
                        toBeLocked = true;
                    }
                } else {
                    toBeRenamed = true;
                }
            }
            if (!sourceWF.getFile().getParentFile().equals(this.newName.getParentFile())) {
                if (sourceWF.getMemberName().getParentFile().equals(this.newName.getParentFile())) {
                    if (toBeReverted) {
                        toBeMoved = false;
                    } else {
                        toBeReverted = true;
                        if (!sourceWF.getMemberName().getName().equals(this.newName.getName())) {
                            toBeRenamed = true;
                            cleanUpSrc = true;
                        }
                        if (sourceWF.isLockedByMe() || sourceWF.isModified()) {
                            toBeLocked = true;
                        }
                    }
                } else {
                    toBeMoved = true;
                }
            }
        }
        Response response = null;
        if (toBeReverted && (response = this.revertDeferred(new WorkingFileList(new WorkingFile[]{sourceWF}))) != null && response.getAPIException() != null) {
            return response;
        }
        if (toBeDropped && (response = this.dropFile(sourceWF)) != null && response.getAPIException() != null) {
            return response;
        }
        if (toBeAdded && (response = this.addFile(targetWF)) != null && response.getAPIException() != null) {
            return response;
        }
        if (toBeRenamed && (response = this.renameFile(sourceWF, targetName = sourceWF.getMemberName().getParentFile().getAbsolutePath() + File.separatorChar + this.newName.getName())) != null && response.getAPIException() != null) {
            return response;
        }
        if (toBeMoved) {
            String sandboxPath = this.determineTargetSandboxPath(sourceWF, targetWF);
            response = this.moveFile(sourceWF, targetWF.getFile().getParentFile().getAbsolutePath(), sandboxPath);
            if (response != null && response.getAPIException() != null) {
                return response;
            }
        }
        if (toBeLocked && (response = this.lockFile(memberWF = WorkingFileFactory.getWorkingFile(this.getCmdRunnerCreator(), sourceWF.getMemberName(), true))) != null && response.getAPIException() != null) {
            return response;
        }
        if (cleanUpSrc && (file = sourceWF.getMemberName()) != null && file.exists()) {
            try {
                file.delete();
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        return null;
    }

    private String determineTargetSandboxPath(WorkingFile sourceWF, WorkingFile targetWF) throws APIException {
        File targetDir = targetWF.getFile().getParentFile();
        String sandboxPath = targetWF.getSandbox();
        if (!sourceWF.getMemberName().getParentFile().equals(targetDir)) {
            File preferredRoot = this.getPreferredRoot();
            if (targetWF.getWorkingRoot() == null && preferredRoot != null) {
                WorkingDirectory wd = WorkingDirectoryFactory.getWorkingDirectory(this.getCmdRunnerCreator(), targetDir, true);
                SandboxInfo sandbox2 = null;
                for (SandboxInfo sandbox2 : wd.getSandboxes()) {
                    if (sandbox2.isRelatedTo(this.getCmdRunnerCreator(), preferredRoot)) break;
                }
                if (sandbox2 != null) {
                    sandboxPath = sandbox2.getSandboxName();
                }
            }
        }
        return sandboxPath;
    }

    private Response addFile(WorkingFile wf) throws APIException {
        SIAddCommand siAdd = new SIAddCommand(this.getCmdRunnerCreator());
        siAdd.setCpid(this.cpid);
        siAdd.setDeferred(true);
        siAdd.setCloseCP(false);
        GenericWFCommandRunner wfAdd = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siAdd);
        return wfAdd.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
    }

    private Response dropFile(WorkingFile wf) throws APIException {
        SIDropCommand siDrop = new SIDropCommand(this.getCmdRunnerCreator());
        siDrop.setCpid(this.cpid);
        siDrop.setDeferred(true);
        siDrop.setCloseCP(false);
        GenericWFCommandRunner wfAdd = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siDrop);
        return wfAdd.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
    }

    private Response renameFile(WorkingFile wf, String newName) throws APIException {
        SIRenameCommand siRename = new SIRenameCommand(this.getCmdRunnerCreator());
        siRename.setCpid(this.cpid);
        siRename.setDeferred(true);
        siRename.setNewName(newName);
        siRename.setRenameFile(true);
        GenericWFCommandRunner wfRename = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siRename);
        return wfRename.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
    }

    private Response moveFile(WorkingFile wf, String targetDir, String targetSandbox) throws APIException {
        SIMoveCommand siMove = new SIMoveCommand(this.getCmdRunnerCreator());
        siMove.setCpid(this.cpid);
        siMove.setDeferred(true);
        siMove.setAllowCreateSubs(this.allowCreateSubs);
        siMove.setMoveWorking(true);
        siMove.setTargetDir(targetDir);
        siMove.setTargetSandbox(targetSandbox);
        GenericWFCommandRunner wfMove = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siMove);
        return wfMove.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
    }

    private Response lockFile(WorkingFile wf) throws APIException {
        SILockCommand siLock = new SILockCommand(this.getCmdRunnerCreator());
        siLock.setCpid(this.cpid);
        siLock.setAllowPrompting(false);
        GenericWFCommandRunner wfLock = new GenericWFCommandRunner(this.getCmdRunnerCreator(), siLock);
        return wfLock.execute(new WorkingFileList(new WorkingFile[]{wf}), this.interactive);
    }

    public void setNewName(String newName) {
        this.newName = new File(newName);
    }
}

