/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.model;

import com.mixpanel.mixpanelapi.featureflags.model.VariantOverride;
import java.util.Collections;
import java.util.Map;
import org.json.JSONObject;

public final class Rollout {
    private final float rolloutPercentage;
    private final JSONObject runtimeEvaluationRule;
    private final Map<String, Object> legacyRuntimeEvaluationDefinition;
    private final VariantOverride variantOverride;
    private final Map<String, Float> variantSplits;

    public Rollout(float rolloutPercentage, JSONObject runtimeEvaluationRule, Map<String, Object> legacyRuntimeEvaluationDefinition, VariantOverride variantOverride, Map<String, Float> variantSplits) {
        this.rolloutPercentage = rolloutPercentage;
        this.legacyRuntimeEvaluationDefinition = legacyRuntimeEvaluationDefinition != null ? Collections.unmodifiableMap(legacyRuntimeEvaluationDefinition) : null;
        this.runtimeEvaluationRule = runtimeEvaluationRule;
        this.variantOverride = variantOverride;
        this.variantSplits = variantSplits != null ? Collections.unmodifiableMap(variantSplits) : null;
    }

    public Rollout(float rolloutPercentage, Map<String, Object> legacyRuntimeEvaluationDefinition, VariantOverride variantOverride, Map<String, Float> variantSplits) {
        this.rolloutPercentage = rolloutPercentage;
        this.legacyRuntimeEvaluationDefinition = legacyRuntimeEvaluationDefinition != null ? Collections.unmodifiableMap(legacyRuntimeEvaluationDefinition) : null;
        this.runtimeEvaluationRule = null;
        this.variantOverride = variantOverride;
        this.variantSplits = variantSplits != null ? Collections.unmodifiableMap(variantSplits) : null;
    }

    public Rollout(float rolloutPercentage) {
        this(rolloutPercentage, null, null, null);
    }

    public float getRolloutPercentage() {
        return this.rolloutPercentage;
    }

    public Map<String, Object> getLegacyRuntimeEvaluationDefinition() {
        return this.legacyRuntimeEvaluationDefinition;
    }

    public VariantOverride getVariantOverride() {
        return this.variantOverride;
    }

    public Map<String, Float> getVariantSplits() {
        return this.variantSplits;
    }

    public boolean hasLegacyRuntimeEvaluation() {
        return this.legacyRuntimeEvaluationDefinition != null && !this.legacyRuntimeEvaluationDefinition.isEmpty();
    }

    public boolean hasRuntimeEvaluation() {
        return this.runtimeEvaluationRule != null && this.runtimeEvaluationRule.length() > 0;
    }

    public boolean hasVariantOverride() {
        return this.variantOverride != null;
    }

    public boolean hasVariantSplits() {
        return this.variantSplits != null && !this.variantSplits.isEmpty();
    }

    public String toString() {
        return "Rollout{rolloutPercentage=" + this.rolloutPercentage + ", legacyRuntimeEvaluationDefinition=" + this.legacyRuntimeEvaluationDefinition + ", runtimeEvaluationRule=" + this.runtimeEvaluationRule + ", variantOverride='" + this.variantOverride + '\'' + ", variantSplits=" + this.variantSplits + '}';
    }

    public JSONObject getRuntimeEvaluationRule() {
        return this.runtimeEvaluationRule;
    }
}

