/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.provider;

import com.mixpanel.mixpanelapi.featureflags.EventSender;
import com.mixpanel.mixpanelapi.featureflags.config.LocalFlagsConfig;
import com.mixpanel.mixpanelapi.featureflags.model.ExperimentationFlag;
import com.mixpanel.mixpanelapi.featureflags.model.Rollout;
import com.mixpanel.mixpanelapi.featureflags.model.RuleSet;
import com.mixpanel.mixpanelapi.featureflags.model.SelectedVariant;
import com.mixpanel.mixpanelapi.featureflags.model.Variant;
import com.mixpanel.mixpanelapi.featureflags.model.VariantOverride;
import com.mixpanel.mixpanelapi.featureflags.provider.BaseFlagsProvider;
import com.mixpanel.mixpanelapi.featureflags.util.HashUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class LocalFlagsProvider
extends BaseFlagsProvider<LocalFlagsConfig>
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LocalFlagsProvider.class.getName());
    private final AtomicReference<Map<String, ExperimentationFlag>> flagDefinitions = new AtomicReference(new HashMap());
    private final AtomicBoolean ready = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private ScheduledExecutorService pollingExecutor;

    public LocalFlagsProvider(LocalFlagsConfig config, String sdkVersion, EventSender eventSender) {
        super(config.getProjectToken(), config, sdkVersion, eventSender);
    }

    public void startPollingForDefinitions() {
        if (this.closed.get()) {
            logger.log(Level.WARNING, "Cannot start polling: provider is closed");
            return;
        }
        this.fetchDefinitions();
        if (((LocalFlagsConfig)this.config).isEnablePolling()) {
            this.pollingExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "mixpanel-flags-poller");
                t.setDaemon(true);
                return t;
            });
            this.pollingExecutor.scheduleAtFixedRate(this::fetchDefinitions, ((LocalFlagsConfig)this.config).getPollingIntervalSeconds(), ((LocalFlagsConfig)this.config).getPollingIntervalSeconds(), TimeUnit.SECONDS);
            logger.log(Level.INFO, "Started polling for flag definitions every " + ((LocalFlagsConfig)this.config).getPollingIntervalSeconds() + " seconds");
        }
    }

    public void stopPollingForDefinitions() {
        if (this.pollingExecutor != null) {
            this.pollingExecutor.shutdown();
            try {
                if (!this.pollingExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.pollingExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.pollingExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            this.pollingExecutor = null;
        }
    }

    public boolean areFlagsReady() {
        return this.ready.get();
    }

    private void fetchDefinitions() {
        try {
            String endpoint = this.buildDefinitionsUrl();
            String response = this.httpGet(endpoint);
            Map<String, ExperimentationFlag> newDefinitions = this.parseDefinitions(response);
            this.flagDefinitions.set(newDefinitions);
            this.ready.set(true);
            logger.log(Level.FINE, "Successfully fetched " + newDefinitions.size() + " flag definitions");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to fetch flag definitions", e);
        }
    }

    private String buildDefinitionsUrl() throws UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        url.append("https://").append(((LocalFlagsConfig)this.config).getApiHost()).append("/flags/definitions");
        url.append("?mp_lib=").append(URLEncoder.encode("java", "UTF-8"));
        url.append("&lib_version=").append(URLEncoder.encode(this.sdkVersion, "UTF-8"));
        url.append("&token=").append(URLEncoder.encode(this.projectToken, "UTF-8"));
        return url.toString();
    }

    private Map<String, ExperimentationFlag> parseDefinitions(String jsonResponse) {
        HashMap<String, ExperimentationFlag> definitions = new HashMap<String, ExperimentationFlag>();
        try {
            JSONObject root = new JSONObject(jsonResponse);
            JSONArray flags = root.optJSONArray("flags");
            if (flags == null) {
                return definitions;
            }
            for (int i = 0; i < flags.length(); ++i) {
                JSONObject flagJson = flags.getJSONObject(i);
                ExperimentationFlag flag = this.parseFlag(flagJson);
                definitions.put(flag.getKey(), flag);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to parse flag definitions", e);
        }
        return definitions;
    }

    private ExperimentationFlag parseFlag(JSONObject json) {
        String id = json.optString("id", "");
        String name = json.optString("name", "");
        String key = json.optString("key", "");
        String status = json.optString("status", "");
        int projectId = json.optInt("project_id", 0);
        String context = json.optString("context", "distinct_id");
        UUID experimentId = null;
        String experimentIdString = json.optString("experiment_id", null);
        if (experimentIdString != null && !experimentIdString.isEmpty()) {
            try {
                experimentId = UUID.fromString(experimentIdString);
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Invalid UUID for experiment_id: " + experimentIdString);
            }
        }
        Boolean isExperimentActive = null;
        if (json.has("is_experiment_active")) {
            isExperimentActive = json.optBoolean("is_experiment_active", false);
        }
        String hashSalt = json.optString("hash_salt", null);
        RuleSet ruleset = this.parseRuleSet(json.optJSONObject("ruleset"));
        return new ExperimentationFlag(id, name, key, status, projectId, ruleset, context, experimentId, isExperimentActive, hashSalt);
    }

    private RuleSet parseRuleSet(JSONObject json) {
        JSONObject usersJson;
        if (json == null) {
            return new RuleSet(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<Variant> variants = new ArrayList<Variant>();
        JSONArray variantsJson = json.optJSONArray("variants");
        if (variantsJson != null) {
            for (int i = 0; i < variantsJson.length(); ++i) {
                variants.add(this.parseVariant(variantsJson.getJSONObject(i)));
            }
        }
        variants.sort(Comparator.comparing(Variant::getKey));
        ArrayList<Rollout> rollouts = new ArrayList<Rollout>();
        JSONArray rolloutsJson = json.optJSONArray("rollout");
        if (rolloutsJson != null) {
            for (int i = 0; i < rolloutsJson.length(); ++i) {
                rollouts.add(this.parseRollout(rolloutsJson.getJSONObject(i)));
            }
        }
        HashMap<String, String> testOverrides = null;
        JSONObject testJson = json.optJSONObject("test");
        if (testJson != null && (usersJson = testJson.optJSONObject("users")) != null) {
            testOverrides = new HashMap<String, String>();
            for (String distinctId : usersJson.keySet()) {
                testOverrides.put(distinctId, usersJson.getString(distinctId));
            }
        }
        return new RuleSet(variants, rollouts, testOverrides);
    }

    private Variant parseVariant(JSONObject json) {
        String key = json.optString("key", "");
        Object value = json.opt("value");
        boolean isControl = json.optBoolean("is_control", false);
        float split = (float)json.optDouble("split", 0.0);
        return new Variant(key, value, isControl, split);
    }

    private Rollout parseRollout(JSONObject json) {
        String key;
        JSONObject variantObj;
        float rolloutPercentage = (float)json.optDouble("rollout_percentage", 0.0);
        VariantOverride variantOverride = null;
        if (json.has("variant_override") && !json.isNull("variant_override") && (variantObj = json.optJSONObject("variant_override")) != null && !(key = variantObj.optString("key", "")).isEmpty()) {
            variantOverride = new VariantOverride(key);
        }
        HashMap<String, Object> runtimeEval = null;
        JSONObject runtimeEvalJson = json.optJSONObject("runtime_evaluation_definition");
        if (runtimeEvalJson != null) {
            runtimeEval = new HashMap<String, Object>();
            for (String key2 : runtimeEvalJson.keySet()) {
                runtimeEval.put(key2, runtimeEvalJson.get(key2));
            }
        }
        HashMap<String, Float> variantSplits = null;
        JSONObject variantSplitsJson = json.optJSONObject("variant_splits");
        if (variantSplitsJson != null) {
            variantSplits = new HashMap<String, Float>();
            for (String key3 : variantSplitsJson.keySet()) {
                variantSplits.put(key3, Float.valueOf((float)variantSplitsJson.optDouble(key3, 0.0)));
            }
        }
        return new Rollout(rolloutPercentage, runtimeEval, variantOverride, variantSplits);
    }

    @Override
    public <T> SelectedVariant<T> getVariant(String flagKey, SelectedVariant<T> fallback, Map<String, Object> context, boolean reportExposure) {
        long startTime = System.currentTimeMillis();
        try {
            Map<String, ExperimentationFlag> definitions = this.flagDefinitions.get();
            ExperimentationFlag flag = definitions.get(flagKey);
            if (flag == null) {
                logger.log(Level.WARNING, "Flag not found: " + flagKey);
                return fallback;
            }
            String contextProperty = flag.getContext();
            Object contextValueObj = context.get(contextProperty);
            if (contextValueObj == null) {
                logger.log(Level.WARNING, "Variant assignment key property '" + contextProperty + "' not found for flag: " + flagKey);
                return fallback;
            }
            String contextValue = contextValueObj.toString();
            RuleSet ruleset = flag.getRuleset();
            Boolean isQaTester = null;
            if (ruleset.hasTestUserOverrides()) {
                Variant variant;
                String testVariantKey;
                String distinctId;
                String string = distinctId = context.get("distinct_id") != null ? context.get("distinct_id").toString() : null;
                if (distinctId != null && (testVariantKey = ruleset.getTestUserOverrides().get(distinctId)) != null && (variant = this.findVariantByKey(ruleset.getVariants(), testVariantKey)) != null) {
                    isQaTester = true;
                    SelectedVariant<Object> result = new SelectedVariant<Object>(variant.getKey(), variant.getValue(), flag.getExperimentId(), flag.getIsExperimentActive(), isQaTester);
                    if (reportExposure) {
                        this.trackLocalExposure(context, flagKey, variant.getKey(), System.currentTimeMillis() - startTime, flag.getExperimentId(), flag.getIsExperimentActive(), isQaTester);
                    }
                    return result;
                }
            }
            List<Rollout> rollouts = ruleset.getRollouts();
            for (int rolloutIndex = 0; rolloutIndex < rollouts.size(); ++rolloutIndex) {
                Rollout rollout = rollouts.get(rolloutIndex);
                float rolloutHash = this.calculateRolloutHash(contextValue, flagKey, flag.getHashSalt(), rolloutIndex);
                if (rolloutHash >= rollout.getRolloutPercentage() || rollout.hasRuntimeEvaluation() && !this.matchesRuntimeConditions(rollout, context)) continue;
                Variant selectedVariant = null;
                if (rollout.hasVariantOverride()) {
                    selectedVariant = this.findVariantByKey(ruleset.getVariants(), rollout.getVariantOverride().getKey());
                } else {
                    float variantHash = this.calculateVariantHash(contextValue, flagKey, flag.getHashSalt());
                    selectedVariant = this.selectVariantBySplit(ruleset.getVariants(), variantHash, rollout);
                }
                if (selectedVariant == null) break;
                if (isQaTester == null) {
                    isQaTester = false;
                }
                SelectedVariant<Object> result = new SelectedVariant<Object>(selectedVariant.getKey(), selectedVariant.getValue(), flag.getExperimentId(), flag.getIsExperimentActive(), isQaTester);
                if (reportExposure) {
                    this.trackLocalExposure(context, flagKey, selectedVariant.getKey(), System.currentTimeMillis() - startTime, flag.getExperimentId(), flag.getIsExperimentActive(), isQaTester);
                }
                return result;
            }
            return fallback;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error evaluating flag: " + flagKey, e);
            return fallback;
        }
    }

    private boolean matchesRuntimeConditions(Rollout rollout, Map<String, Object> context) {
        Map<String, Object> customProperties = this.getCustomProperties(context);
        if (customProperties == null) {
            return false;
        }
        Map<String, Object> runtimeEval = rollout.getRuntimeEvaluationDefinition();
        for (Map.Entry<String, Object> entry : runtimeEval.entrySet()) {
            Object actualValue;
            String key = entry.getKey();
            Object expectedValue = entry.getValue();
            if (this.valuesEqual(expectedValue, actualValue = customProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> getCustomProperties(Map<String, Object> context) {
        Object customPropsObj = context.get("custom_properties");
        if (customPropsObj instanceof Map) {
            return (Map)customPropsObj;
        }
        return null;
    }

    private boolean valuesEqual(Object expected, Object actual) {
        if (expected == null || actual == null) {
            return expected == actual;
        }
        if (expected instanceof String && actual instanceof String) {
            return ((String)expected).equalsIgnoreCase((String)actual);
        }
        return expected.equals(actual);
    }

    private Variant findVariantByKey(List<Variant> variants, String key) {
        for (Variant variant : variants) {
            if (!variant.getKey().equals(key)) continue;
            return variant;
        }
        return null;
    }

    private List<Variant> applyVariantSplitOverrides(List<Variant> variants, Map<String, Float> variantSplits) {
        ArrayList<Variant> result = new ArrayList<Variant>(variants.size());
        for (Variant variant : variants) {
            if (variantSplits.containsKey(variant.getKey())) {
                float overriddenSplit = variantSplits.get(variant.getKey()).floatValue();
                Variant updatedVariant = new Variant(variant.getKey(), variant.getValue(), variant.isControl(), overriddenSplit);
                result.add(updatedVariant);
                continue;
            }
            result.add(variant);
        }
        return result;
    }

    private Variant selectVariantBySplit(List<Variant> variants, float hash, Rollout rollout) {
        List<Variant> variantsToUse = variants;
        if (rollout != null && rollout.hasVariantSplits()) {
            variantsToUse = this.applyVariantSplitOverrides(variants, rollout.getVariantSplits());
        }
        float cumulative = 0.0f;
        for (Variant variant : variantsToUse) {
            if (!(hash < (cumulative += variant.getSplit()))) continue;
            return variant;
        }
        return variantsToUse.isEmpty() ? null : variantsToUse.get(variantsToUse.size() - 1);
    }

    protected float calculateRolloutHash(String contextValue, String flagKey, String hashSalt, int rolloutIndex) {
        if (hashSalt != null && !hashSalt.isEmpty()) {
            return HashUtils.normalizedHash(contextValue + flagKey, hashSalt + rolloutIndex);
        }
        return HashUtils.normalizedHash(contextValue + flagKey, "rollout");
    }

    protected float calculateVariantHash(String contextValue, String flagKey, String hashSalt) {
        if (hashSalt != null && !hashSalt.isEmpty()) {
            return HashUtils.normalizedHash(contextValue + flagKey, hashSalt + "variant");
        }
        return HashUtils.normalizedHash(contextValue + flagKey, "variant");
    }

    public List<SelectedVariant<Object>> getAllVariants(Map<String, Object> context, boolean reportExposure) {
        ArrayList<SelectedVariant<Object>> results = new ArrayList<SelectedVariant<Object>>();
        Map<String, ExperimentationFlag> definitions = this.flagDefinitions.get();
        for (ExperimentationFlag flag : definitions.values()) {
            SelectedVariant<Object> fallback = new SelectedVariant<Object>(null);
            SelectedVariant<Object> result = this.getVariant(flag.getKey(), fallback, context, reportExposure);
            if (!result.isSuccess()) continue;
            results.add(result);
        }
        return results;
    }

    private void trackLocalExposure(Map<String, Object> context, String flagKey, String variantKey, long latencyMs, UUID experimentId, Boolean isExperimentActive, Boolean isQaTester) {
        if (this.eventSender == null) {
            return;
        }
        Object distinctIdObj = context.get("distinct_id");
        if (distinctIdObj == null) {
            return;
        }
        this.trackExposure(distinctIdObj.toString(), flagKey, variantKey, "local", properties -> properties.put("Variant fetch latency (ms)", latencyMs), experimentId, isExperimentActive, isQaTester);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.stopPollingForDefinitions();
        }
    }
}

