/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi.featureflags.model;

import com.mixpanel.mixpanelapi.featureflags.model.VariantOverride;
import java.util.Collections;
import java.util.Map;

public final class Rollout {
    private final float rolloutPercentage;
    private final Map<String, Object> runtimeEvaluationDefinition;
    private final VariantOverride variantOverride;
    private final Map<String, Float> variantSplits;

    public Rollout(float rolloutPercentage, Map<String, Object> runtimeEvaluationDefinition, VariantOverride variantOverride, Map<String, Float> variantSplits) {
        this.rolloutPercentage = rolloutPercentage;
        this.runtimeEvaluationDefinition = runtimeEvaluationDefinition != null ? Collections.unmodifiableMap(runtimeEvaluationDefinition) : null;
        this.variantOverride = variantOverride;
        this.variantSplits = variantSplits != null ? Collections.unmodifiableMap(variantSplits) : null;
    }

    public Rollout(float rolloutPercentage) {
        this(rolloutPercentage, null, null, null);
    }

    public float getRolloutPercentage() {
        return this.rolloutPercentage;
    }

    public Map<String, Object> getRuntimeEvaluationDefinition() {
        return this.runtimeEvaluationDefinition;
    }

    public VariantOverride getVariantOverride() {
        return this.variantOverride;
    }

    public Map<String, Float> getVariantSplits() {
        return this.variantSplits;
    }

    public boolean hasRuntimeEvaluation() {
        return this.runtimeEvaluationDefinition != null && !this.runtimeEvaluationDefinition.isEmpty();
    }

    public boolean hasVariantOverride() {
        return this.variantOverride != null;
    }

    public boolean hasVariantSplits() {
        return this.variantSplits != null && !this.variantSplits.isEmpty();
    }

    public String toString() {
        return "Rollout{rolloutPercentage=" + this.rolloutPercentage + ", runtimeEvaluationDefinition=" + this.runtimeEvaluationDefinition + ", variantOverride='" + this.variantOverride + '\'' + ", variantSplits=" + this.variantSplits + '}';
    }
}

