/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import com.mixpanel.mixpanelapi.MixpanelMessageException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientDelivery {
    private final List<JSONObject> mEventsMessages = new ArrayList<JSONObject>();
    private final List<JSONObject> mPeopleMessages = new ArrayList<JSONObject>();
    private final List<JSONObject> mGroupMessages = new ArrayList<JSONObject>();
    private final List<JSONObject> mImportMessages = new ArrayList<JSONObject>();

    public void addMessage(JSONObject message) {
        if (!this.isValidMessage(message)) {
            throw new MixpanelMessageException("Given JSONObject was not a valid Mixpanel message", message);
        }
        try {
            String messageType = message.getString("message_type");
            JSONObject messageContent = message.getJSONObject("message");
            if (messageType.equals("event")) {
                this.mEventsMessages.add(messageContent);
            } else if (messageType.equals("people")) {
                this.mPeopleMessages.add(messageContent);
            } else if (messageType.equals("group")) {
                this.mGroupMessages.add(messageContent);
            } else if (messageType.equals("import")) {
                this.mImportMessages.add(messageContent);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Apparently valid mixpanel message could not be interpreted.", e);
        }
    }

    public boolean isValidMessage(JSONObject message) {
        boolean ret = true;
        try {
            int envelopeVersion = message.getInt("envelope_version");
            if (envelopeVersion > 0) {
                String messageType = message.getString("message_type");
                JSONObject messageContents = message.getJSONObject("message");
                if (messageContents == null) {
                    ret = false;
                } else if (!(messageType.equals("event") || messageType.equals("people") || messageType.equals("group") || messageType.equals("import"))) {
                    ret = false;
                }
            }
        }
        catch (JSONException e) {
            ret = false;
        }
        return ret;
    }

    List<JSONObject> getEventsMessages() {
        return this.mEventsMessages;
    }

    List<JSONObject> getPeopleMessages() {
        return this.mPeopleMessages;
    }

    List<JSONObject> getGroupMessages() {
        return this.mGroupMessages;
    }

    List<JSONObject> getImportMessages() {
        return this.mImportMessages;
    }
}

