/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import com.mixpanel.mixpanelapi.Base64Coder;
import com.mixpanel.mixpanelapi.ClientDelivery;
import com.mixpanel.mixpanelapi.MixpanelMessageException;
import com.mixpanel.mixpanelapi.MixpanelServerException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelAPI {
    private static final int BUFFER_SIZE = 256;
    private static final int CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    protected final String mEventsEndpoint;
    protected final String mPeopleEndpoint;
    protected final String mGroupsEndpoint;
    protected final String mImportEndpoint;
    protected final boolean mUseGzipCompression;

    public MixpanelAPI() {
        this(false);
    }

    public MixpanelAPI(boolean useGzipCompression) {
        this("https://api.mixpanel.com/track", "https://api.mixpanel.com/engage", "https://api.mixpanel.com/groups", "https://api.mixpanel.com/import", useGzipCompression);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint) {
        this(eventsEndpoint, peopleEndpoint, "https://api.mixpanel.com/groups", "https://api.mixpanel.com/import", false);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint) {
        this(eventsEndpoint, peopleEndpoint, groupsEndpoint, "https://api.mixpanel.com/import", false);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint, String importEndpoint) {
        this(eventsEndpoint, peopleEndpoint, groupsEndpoint, importEndpoint, false);
    }

    public MixpanelAPI(String eventsEndpoint, String peopleEndpoint, String groupsEndpoint, String importEndpoint, boolean useGzipCompression) {
        this.mEventsEndpoint = eventsEndpoint;
        this.mPeopleEndpoint = peopleEndpoint;
        this.mGroupsEndpoint = groupsEndpoint;
        this.mImportEndpoint = importEndpoint;
        this.mUseGzipCompression = useGzipCompression;
    }

    public void sendMessage(JSONObject message) throws MixpanelMessageException, IOException {
        ClientDelivery delivery = new ClientDelivery();
        delivery.addMessage(message);
        this.deliver(delivery);
    }

    public void deliver(ClientDelivery toSend) throws IOException {
        this.deliver(toSend, false);
    }

    public void deliver(ClientDelivery toSend, boolean useIpAddress) throws IOException {
        String ipParameter = "ip=0";
        if (useIpAddress) {
            ipParameter = "ip=1";
        }
        String eventsUrl = this.mEventsEndpoint + "?" + ipParameter;
        List<JSONObject> events = toSend.getEventsMessages();
        this.sendMessages(events, eventsUrl);
        String peopleUrl = this.mPeopleEndpoint + "?" + ipParameter;
        List<JSONObject> people = toSend.getPeopleMessages();
        this.sendMessages(people, peopleUrl);
        String groupsUrl = this.mGroupsEndpoint + "?" + ipParameter;
        List<JSONObject> groupMessages = toSend.getGroupMessages();
        this.sendMessages(groupMessages, groupsUrl);
        List<JSONObject> importMessages = toSend.getImportMessages();
        if (importMessages.size() > 0) {
            String importUrl = this.mImportEndpoint + "?strict=1";
            this.sendImportMessages(importMessages, importUrl);
        }
    }

    protected String encodeDataString(String dataString) {
        try {
            byte[] utf8data = dataString.getBytes("utf-8");
            String base64data = new String(Base64Coder.encode(utf8data));
            return URLEncoder.encode(base64data, "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 support", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendData(String dataString, String endpointUrl) throws IOException {
        byte[] dataToSend;
        String encodedQuery2;
        String encodedData;
        URL endpoint = new URL(endpointUrl);
        URLConnection conn = endpoint.openConnection();
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(2000);
        conn.setDoOutput(true);
        if (this.mUseGzipCompression) {
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
            conn.setRequestProperty("Content-Encoding", "gzip");
            encodedData = this.encodeDataString(dataString);
            encodedQuery2 = "data=" + encodedData;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(byteStream);
                gzipStream.write(encodedQuery2.getBytes("utf-8"));
                gzipStream.finish();
                dataToSend = byteStream.toByteArray();
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf8");
        encodedData = this.encodeDataString(dataString);
        encodedQuery2 = "data=" + encodedData;
        dataToSend = encodedQuery2.getBytes("utf-8");
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(dataToSend);
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException encodedQuery2) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return response != null && response.equals("1");
    }

    private void sendMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        for (int i = 0; i < messages.size(); i += 50) {
            String messagesString;
            boolean accepted;
            int endIndex = i + 50;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendData(messagesString = this.dataString(batch), endpointUrl))) continue;
            throw new MixpanelServerException("Server refused to accept messages, they may be malformed.", batch);
        }
    }

    private void sendImportMessages(List<JSONObject> messages, String endpointUrl) throws IOException {
        String token = "";
        if (messages.size() > 0) {
            try {
                JSONObject properties;
                JSONObject firstMessage = messages.get(0);
                if (firstMessage.has("properties") && (properties = firstMessage.getJSONObject("properties")).has("token")) {
                    token = properties.getString("token");
                }
            }
            catch (JSONException firstMessage) {
                // empty catch block
            }
        }
        for (int i = 0; i < messages.size(); i += 2000) {
            String messagesString;
            boolean accepted;
            int endIndex = i + 2000;
            List<JSONObject> batch = messages.subList(i, endIndex = Math.min(endIndex, messages.size()));
            if (batch.size() <= 0 || (accepted = this.sendImportData(messagesString = this.dataString(batch), endpointUrl, token))) continue;
            throw new MixpanelServerException("Server refused to accept import messages, they may be malformed.", batch);
        }
    }

    private String dataString(List<JSONObject> messages) {
        JSONArray array = new JSONArray();
        for (JSONObject message : messages) {
            array.put((Object)message);
        }
        return array.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean sendImportData(String dataString, String endpointUrl, String token) throws IOException {
        byte[] dataToSend;
        URL endpoint = new URL(endpointUrl);
        HttpURLConnection conn = (HttpURLConnection)endpoint.openConnection();
        conn.setReadTimeout(10000);
        conn.setConnectTimeout(2000);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        try {
            String authString = token + ":";
            byte[] authBytes = authString.getBytes("utf-8");
            String base64Auth = new String(Base64Coder.encode(authBytes));
            conn.setRequestProperty("Authorization", "Basic " + base64Auth);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Mixpanel library requires utf-8 support", e);
        }
        if (this.mUseGzipCompression) {
            conn.setRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipStream = null;
            try {
                gzipStream = new GZIPOutputStream(byteStream);
                gzipStream.write(dataString.getBytes("utf-8"));
                gzipStream.finish();
                dataToSend = byteStream.toByteArray();
            }
            finally {
                if (gzipStream != null) {
                    try {
                        gzipStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        dataToSend = dataString.getBytes("utf-8");
        OutputStream postStream = null;
        try {
            postStream = conn.getOutputStream();
            postStream.write(dataToSend);
        }
        finally {
            if (postStream != null) {
                try {
                    postStream.close();
                }
                catch (IOException gzipStream) {}
            }
        }
        InputStream responseStream = null;
        String response = null;
        try {
            responseStream = conn.getInputStream();
            response = this.slurp(responseStream);
        }
        catch (IOException e) {
            InputStream errorStream = conn.getErrorStream();
            if (errorStream == null) throw e;
            try {
                this.slurp(errorStream);
                errorStream.close();
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                throw e;
            }
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (response == null) {
            return false;
        }
        try {
            JSONObject jsonResponse = new JSONObject(response);
            boolean statusOk = jsonResponse.has("status") && "OK".equals(jsonResponse.getString("status"));
            boolean codeOk = jsonResponse.has("code") && jsonResponse.getInt("code") == 200;
            if (!statusOk) return false;
            if (!codeOk) return false;
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private String slurp(InputStream in) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, "utf8");
        char[] readBuffer = new char[256];
        int readCount = 0;
        do {
            if ((readCount = reader.read(readBuffer)) <= 0) continue;
            out.append(readBuffer, 0, readCount);
        } while (readCount != -1);
        return out.toString();
    }
}

