/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.mixpanelapi;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBuilder {
    private final String mToken;
    private static final String ENGAGE_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public MessageBuilder(String token) {
        this.mToken = token;
    }

    public JSONObject event(String distinctId, String eventName, JSONObject properties) {
        long time = System.currentTimeMillis() / 1000L;
        try {
            JSONObject dataObj = new JSONObject();
            dataObj.put("event", (Object)eventName);
            JSONObject propertiesObj = null;
            propertiesObj = properties == null ? new JSONObject() : new JSONObject(properties.toString());
            if (!propertiesObj.has("token")) {
                propertiesObj.put("token", (Object)this.mToken);
            }
            if (!propertiesObj.has("time")) {
                propertiesObj.put("time", time);
            }
            if (!propertiesObj.has("mp_lib")) {
                propertiesObj.put("mp_lib", (Object)"jdk");
            }
            if (distinctId != null) {
                propertiesObj.put("distinct_id", (Object)distinctId);
            }
            dataObj.put("properties", (Object)propertiesObj);
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"event");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }

    public JSONObject set(String distinctId, JSONObject properties) {
        return this.stdPeopleMessage(distinctId, "$set", properties);
    }

    public JSONObject increment(String distinctId, Map<String, Long> properties) {
        JSONObject jsonProperties = new JSONObject(properties);
        return this.stdPeopleMessage(distinctId, "$add", jsonProperties);
    }

    public JSONObject append(String distinctId, JSONObject properties) {
        return this.stdPeopleMessage(distinctId, "$append", properties);
    }

    public JSONObject trackCharge(String distinctId, double amount, JSONObject properties) {
        JSONObject transactionValue = new JSONObject();
        JSONObject appendProperties = new JSONObject();
        try {
            transactionValue.put("$amount", amount);
            SimpleDateFormat dateFormat = new SimpleDateFormat(ENGAGE_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            transactionValue.put("$time", (Object)dateFormat.format(new Date()));
            if (null != properties) {
                Iterator iter = properties.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    transactionValue.put(key, properties.get(key));
                }
            }
            appendProperties.put("$transactions", (Object)transactionValue);
            return this.append(distinctId, appendProperties);
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot create trackCharge message", e);
        }
    }

    private JSONObject stdPeopleMessage(String distinctId, String actionType, JSONObject properties) {
        try {
            JSONObject dataObj = new JSONObject();
            dataObj.put(actionType, (Object)properties);
            dataObj.put("$token", (Object)this.mToken);
            dataObj.put("$distinct_id", (Object)distinctId);
            dataObj.put("$time", System.currentTimeMillis());
            JSONObject envelope = new JSONObject();
            envelope.put("envelope_version", 1);
            envelope.put("message_type", (Object)"people");
            envelope.put("message", (Object)dataObj);
            return envelope;
        }
        catch (JSONException e) {
            throw new RuntimeException("Can't construct a Mixpanel message", e);
        }
    }
}

