/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public interface RemoteService {
    public boolean isOnline(Context var1, OfflineMode var2);

    public void checkIsServerBlocked();

    public RequestResult performRequest(@NonNull String var1, @Nullable ProxyServerInteractor var2, @Nullable Map<String, Object> var3, @Nullable Map<String, String> var4, @Nullable byte[] var5, @Nullable SSLSocketFactory var6) throws ServiceUnavailableException, IOException;

    public RequestResult performRequest(@NonNull HttpMethod var1, @NonNull String var2, @Nullable ProxyServerInteractor var3, @Nullable Map<String, Object> var4, @Nullable Map<String, String> var5, @Nullable byte[] var6, @Nullable SSLSocketFactory var7) throws ServiceUnavailableException, IOException;

    public static class RequestResult {
        private final byte[] response;
        private final Exception exception;
        private final boolean isClientError;
        private final boolean success;
        private final String requestUrl;

        public RequestResult(byte[] response, String requestUrl) {
            this.response = response;
            this.requestUrl = requestUrl;
            this.exception = null;
            this.isClientError = false;
            this.success = true;
        }

        public RequestResult(Exception exception, boolean isClientError, String requestUrl) {
            this.response = null;
            this.requestUrl = requestUrl;
            this.exception = exception;
            this.isClientError = isClientError;
            this.success = false;
        }

        public static RequestResult success(byte[] response, String requestUrl) {
            return new RequestResult(response, requestUrl);
        }

        public static RequestResult failure(Exception exception, boolean isClientError, String requestUrl) {
            return new RequestResult(exception, isClientError, requestUrl);
        }

        public byte[] getResponse() {
            return this.response;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isClientError() {
            return this.isClientError;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }
    }

    public static class ClientErrorException
    extends IOException {
        private final int responseCode;

        public ClientErrorException(int responseCode, String message) {
            super("Client error " + responseCode + ": " + message);
            this.responseCode = responseCode;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }

    public static class ServiceUnavailableException
    extends Exception {
        private final int mRetryAfter;

        public ServiceUnavailableException(String message, String strRetryAfter) {
            super(message);
            int retry;
            try {
                retry = Integer.parseInt(strRetryAfter);
            }
            catch (NumberFormatException e) {
                retry = 0;
            }
            this.mRetryAfter = retry;
        }

        public int getRetryAfter() {
            return this.mRetryAfter;
        }
    }

    public static enum HttpMethod {
        GET,
        POST;

    }
}

